/*
 * Decompiled with CFR 0.152.
 */
package mc.ajneb97.tasks;

import mc.ajneb97.MineChess;
import mc.ajneb97.manager.GamePlayerManager;
import mc.ajneb97.manager.MessagesManager;
import mc.ajneb97.model.Arena;
import mc.ajneb97.model.game.GameEndsReason;
import mc.ajneb97.model.game.GameLeaveReason;
import mc.ajneb97.model.game.GamePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ArenaCooldownManager {
    private MineChess plugin;
    private Arena arena;
    private boolean stop;
    private int time;

    public ArenaCooldownManager(MineChess plugin, Arena arena, int time) {
        this.plugin = plugin;
        this.arena = arena;
        this.stop = false;
        this.time = time;
    }

    public boolean isStop() {
        return this.stop;
    }

    public int getTime() {
        return this.time;
    }

    public void stop() {
        this.stop = true;
    }

    public void start() {
        new BukkitRunnable(){

            public void run() {
                if (ArenaCooldownManager.this.stop) {
                    this.cancel();
                } else {
                    ArenaCooldownManager.this.execute();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    public void execute() {
        switch (this.arena.getStatus()) {
            case WAITING: 
            case DISABLED: {
                break;
            }
            case STARTING: {
                this.executeStarting();
                break;
            }
            case PLAYING: {
                this.executePlaying();
                break;
            }
            case ENDING: {
                this.executeEnding();
            }
        }
        if (this.time > 0) {
            --this.time;
        }
    }

    private void executeStarting() {
        if (this.time > 0 && this.time <= 5) {
            MessagesManager msgManager = this.plugin.getMessagesManager();
            FileConfiguration messagesConfig = this.plugin.getMessagesConfig();
            for (GamePlayer p : this.arena.getGamePlayers()) {
                msgManager.sendMessage((CommandSender)p.getPlayer(), messagesConfig.getString("gameStarting").replace("%time%", "" + this.time), true);
            }
        } else if (this.time == 0) {
            this.plugin.getArenaManager().startPlayingStage(this.arena);
        }
    }

    private void executePlaying() {
        GamePlayerManager gamePlayerManager = this.plugin.getArenaManager().getGamePlayerManager();
        if (this.time == 0) {
            this.plugin.getArenaManager().getGameEndManager().startEndingStage(this.arena, GameEndsReason.TIME);
            return;
        }
        GamePlayer playerTurn = this.arena.getPlayerTurn();
        if (playerTurn.getTurnTime() <= 0) {
            this.plugin.getArenaManager().automaticMove(this.arena);
        } else {
            this.arena.getPlayerTurn().reduceTurnTime();
        }
        gamePlayerManager.showActionbar(this.arena);
    }

    private void executeEnding() {
        if (this.time == 0) {
            this.plugin.getArenaManager().getGameEndManager().endGame(this.arena, GameLeaveReason.END_GAME);
        } else {
            this.plugin.getArenaManager().winnersFireworks(this.arena);
        }
    }
}

