/*
 * Decompiled with CFR 0.152.
 */
package mc.ajneb97.utils;

import mc.ajneb97.MineChess;
import mc.ajneb97.manager.MessagesManager;
import mc.ajneb97.utils.ServerVersion;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class OtherUtils {
    public static boolean isNew() {
        ServerVersion serverVersion = MineChess.serverVersion;
        return serverVersion.serverVersionGreaterEqualThan(serverVersion, ServerVersion.v1_16_R1);
    }

    public static boolean isLegacy() {
        ServerVersion serverVersion = MineChess.serverVersion;
        return !serverVersion.serverVersionGreaterEqualThan(serverVersion, ServerVersion.v1_13_R1);
    }

    public static boolean isTrimNew() {
        ServerVersion serverVersion = MineChess.serverVersion;
        return serverVersion.serverVersionGreaterEqualThan(serverVersion, ServerVersion.v1_20_R1);
    }

    public static String replaceGlobalVariables(String text, Player player, MineChess plugin) {
        if (player == null) {
            return text;
        }
        text = text.replace("%player%", player.getName());
        if (plugin.getDependencyManager().isPlaceholderAPI()) {
            text = PlaceholderAPI.setPlaceholders((Player)player, (String)text);
        }
        return text;
    }

    public static String getTimeFormat1(int seconds) {
        int minutes = seconds / 60;
        int secondsRes = seconds - minutes * 60;
        Object secondsMsg = "";
        Object minutesMsg = "";
        secondsMsg = secondsRes >= 0 && secondsRes <= 9 ? "0" + secondsRes : "" + secondsRes;
        minutesMsg = minutes >= 0 && minutes <= 9 ? "0" + minutes : "" + minutes;
        return (String)minutesMsg + ":" + (String)secondsMsg;
    }

    public static String getTimeFormat2(long seconds, MessagesManager msgManager) {
        long totalMinWait = seconds / 60L;
        long totalHourWait = totalMinWait / 60L;
        long totalDayWait = totalHourWait / 24L;
        Object time = "";
        if (seconds > 59L) {
            seconds -= 60L * totalMinWait;
        }
        if (seconds > 0L) {
            time = seconds + msgManager.getTimeSeconds();
        }
        if (totalMinWait > 59L) {
            totalMinWait -= 60L * totalHourWait;
        }
        if (totalMinWait > 0L) {
            time = totalMinWait + msgManager.getTimeMinutes() + " " + (String)time;
        }
        if (totalHourWait > 23L) {
            totalHourWait -= 24L * totalDayWait;
        }
        if (totalHourWait > 0L) {
            time = totalHourWait + msgManager.getTimeHours() + " " + (String)time;
        }
        if (totalDayWait > 0L) {
            time = totalDayWait + msgManager.getTimeDays() + " " + (String)time;
        }
        if (((String)time).endsWith(" ")) {
            time = ((String)time).substring(0, ((String)time).length() - 1);
        }
        return time;
    }

    public static Color getFireworkColorFromName(String colorName) {
        try {
            return (Color)Color.class.getDeclaredField(colorName).get(Color.class);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean isChunkLoaded(Location location) {
        int chunkX = location.getBlockX() >> 4;
        int chunkZ = location.getBlockZ() >> 4;
        return location.getWorld().isChunkLoaded(chunkX, chunkZ);
    }
}

