/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.onlypaxel;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class ModConfigs {
    private static final File CONFIG_FILE = new File("config/onlypaxel.toml");
    public static int durabilityWoodenPaxel = 177;
    public static int durabilityStonePaxel = 393;
    public static int durabilityIronPaxel = 750;
    public static int durabilityGoldenPaxel = 96;
    public static int durabilityDiamondPaxel = 4683;
    public static int durabilityNetheritePaxel = 6093;

    public static void loadConfig() {
        File configDir = new File("config");
        if (!configDir.exists()) {
            configDir.mkdir();
        }
        if (!CONFIG_FILE.exists()) {
            ModConfigs.saveConfig();
        } else {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                JsonObject config = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                durabilityWoodenPaxel = config.get("durabilityWoodenPaxel").getAsInt();
                durabilityStonePaxel = config.get("durabilityStonePaxel").getAsInt();
                durabilityIronPaxel = config.get("durabilityIronPaxel").getAsInt();
                durabilityGoldenPaxel = config.get("durabilityGoldenPaxel").getAsInt();
                durabilityDiamondPaxel = config.get("durabilityDiamondPaxel").getAsInt();
                durabilityNetheritePaxel = config.get("durabilityNetheritePaxel").getAsInt();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void saveConfig() {
        JsonObject config = new JsonObject();
        config.addProperty("durabilityWoodenPaxel", (Number)durabilityWoodenPaxel);
        config.addProperty("durabilityStonePaxel", (Number)durabilityStonePaxel);
        config.addProperty("durabilityIronPaxel", (Number)durabilityIronPaxel);
        config.addProperty("durabilityGoldenPaxel", (Number)durabilityGoldenPaxel);
        config.addProperty("durabilityDiamondPaxel", (Number)durabilityDiamondPaxel);
        config.addProperty("durabilityNetheritePaxel", (Number)durabilityNetheritePaxel);
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            writer.write(gson.toJson((JsonElement)config));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

