/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.onlypaxel.item.custom;

import com.blocklegend001.onlypaxel.utils.ModTags;
import com.google.common.collect.BiMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class Paxel
extends Item {
    private static final Map<Block, BlockState> FLATTENABLES = Shovel.getFlattenables();
    private static final Map<Block, Block> STRIPPABLES = Axe.getStrippables();
    private static TagKey<Block> paxelMineable = ModTags.Blocks.PAXEL_MINEABLE;
    private final ToolMaterial tier;

    public Paxel(ToolMaterial tier, float attackDamage, float attackSpeed, Item.Properties properties) {
        super(Paxel.computeProperties(tier, ModTags.Blocks.PAXEL_MINEABLE, attackDamage, attackSpeed, properties));
        this.tier = tier;
    }

    public ToolMaterial getTier() {
        return this.tier;
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        stack.get(DataComponents.TOOL);
        return state.is(paxelMineable) ? this.tier.speed() : 1.0f;
    }

    public boolean mineBlock(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity user) {
        if (!world.isClientSide() && state.is(paxelMineable)) {
            world.setBlock(pos, state, 11);
            if (user != null) {
                user.getMainHandItem().hurtAndBreak(1, user, InteractionHand.MAIN_HAND);
            }
            return true;
        }
        return false;
    }

    private static Item.Properties computeProperties(ToolMaterial tier, TagKey<Block> paxelMineable, float attackDamage, float attackSpeed, Item.Properties properties) {
        Paxel.paxelMineable = paxelMineable;
        properties.pickaxe(Paxel.wrapMaterial(tier, tier.durability()), attackDamage, attackSpeed);
        properties.shovel(Paxel.wrapMaterial(tier, tier.durability()), attackDamage, attackSpeed);
        properties.axe(Paxel.wrapMaterial(tier, tier.durability()), attackDamage, attackSpeed);
        properties.tool(tier, BlockTags.MINEABLE_WITH_PICKAXE, attackDamage, attackSpeed, 0.0f);
        return properties;
    }

    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        BlockState state = world.getBlockState(pos);
        BlockState result = this.getModifiedBlockState(context, state, pos);
        if (Paxel.playerHasShieldUseIntent(context)) {
            return InteractionResult.PASS;
        }
        if (result == null) {
            return InteractionResult.PASS;
        }
        if (!world.isClientSide()) {
            world.setBlock(pos, result, 11);
            if (player != null) {
                context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, InteractionHand.MAIN_HAND);
            }
        }
        return InteractionResult.SUCCESS;
    }

    private BlockState getModifiedBlockState(UseOnContext context, BlockState state, BlockPos pos) {
        Level world = context.getLevel();
        Player player = context.getPlayer();
        if (STRIPPABLES.containsKey(state.getBlock())) {
            world.playSound((Entity)player, pos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
            return (BlockState)STRIPPABLES.get(state.getBlock()).defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)((Direction.Axis)state.getValue((Property)RotatedPillarBlock.AXIS)));
        }
        Optional<BlockState> newState = this.evaluateNewBlockState(world, pos, player, state);
        if (newState.isPresent()) {
            return newState.get();
        }
        if (context.getClickedFace() == Direction.DOWN) {
            return null;
        }
        if (FLATTENABLES.containsKey(state.getBlock()) && world.getBlockState(pos.above()).isAir()) {
            world.playSound((Entity)player, pos, SoundEvents.SHOVEL_FLATTEN, SoundSource.BLOCKS, 1.0f, 1.0f);
            return FLATTENABLES.get(state.getBlock());
        }
        if (state.getBlock() instanceof CampfireBlock && ((Boolean)state.getValue((Property)CampfireBlock.LIT)).booleanValue()) {
            world.playSound((Entity)player, pos, SoundEvents.AXE_SCRAPE, SoundSource.BLOCKS, 1.0f, 1.0f);
            return (BlockState)state.setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false));
        }
        return null;
    }

    private static boolean playerHasShieldUseIntent(UseOnContext context) {
        Player player = context.getPlayer();
        return context.getHand().equals((Object)InteractionHand.MAIN_HAND) && player.getOffhandItem().is(Items.SHIELD) && !player.isSecondaryUseActive();
    }

    private Optional<BlockState> evaluateNewBlockState(Level world, BlockPos pos, @Nullable Player player, BlockState state) {
        Optional<BlockState> optional = this.getStripped(state);
        if (optional.isPresent()) {
            world.playSound((Entity)player, pos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
            return optional;
        }
        Optional optional1 = WeatheringCopper.getPrevious((BlockState)state);
        if (optional1.isPresent()) {
            world.playSound((Entity)player, pos, SoundEvents.AXE_SCRAPE, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.levelEvent((Entity)player, 3005, pos, 0);
            return optional1;
        }
        Optional<BlockState> optional2 = Optional.ofNullable((Block)((BiMap)HoneycombItem.WAX_OFF_BY_BLOCK.get()).get((Object)state.getBlock())).map(block -> block.withPropertiesOf(state));
        if (optional2.isPresent()) {
            world.playSound((Entity)player, pos, SoundEvents.AXE_WAX_OFF, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.levelEvent((Entity)player, 3004, pos, 0);
            return optional2;
        }
        return Optional.empty();
    }

    private static ToolMaterial wrapMaterial(ToolMaterial toolMaterial, int durability) {
        return new ToolMaterial(toolMaterial.incorrectBlocksForDrops(), durability, toolMaterial.speed(), toolMaterial.attackDamageBonus(), toolMaterial.enchantmentValue(), toolMaterial.repairItems());
    }

    private Optional<BlockState> getStripped(BlockState state) {
        return Optional.ofNullable(STRIPPABLES.get(state.getBlock())).map(block -> (BlockState)block.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)((Direction.Axis)state.getValue((Property)RotatedPillarBlock.AXIS))));
    }

    private static final class Shovel
    extends ShovelItem {
        public static Map<Block, BlockState> getFlattenables() {
            return ShovelItem.FLATTENABLES;
        }

        private Shovel(ToolMaterial pTier, float attackDamage, float attackSpeed, Item.Properties properties) {
            super(pTier, attackDamage, attackSpeed, properties);
        }
    }

    private static final class Axe
    extends AxeItem {
        public static Map<Block, Block> getStrippables() {
            return AxeItem.STRIPPABLES;
        }

        private Axe(ToolMaterial pTier, float attackDamage, float attackSpeed, Item.Properties properties) {
            super(pTier, attackDamage, attackSpeed, properties);
        }
    }
}

