/*
 * Decompiled with CFR 0.152.
 */
package org.gneisscode.improvedmapcolors;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.world.level.material.MapColor;
import org.gneisscode.improvedmapcolors.CommonConfig;
import org.gneisscode.improvedmapcolors.networking.ColorListSyncPayload;
import org.jetbrains.annotations.Nullable;

public class ColorListManager {
    @Nullable
    private static @Nullable List<@Nullable Color> configColorList = new ArrayList<Color>();
    @Nullable
    private static @Nullable List<@Nullable Color> datapackColorList = new ArrayList<Color>();
    @Nullable
    private static @Nullable List<@Nullable Color> overridingColorList = new ArrayList<Color>();
    @Nullable
    private static Color[] serverColors = null;
    public static final Supplier<Boolean> runConfigColors = () -> ((CommonConfig.ConfigMode)((Object)((Object)CommonConfig.CONFIG.colorConfigMode.get()))).hasModConfig() && configColorList != null && configColorList.size() == MapColor.MATERIAL_COLORS.length;
    public static final Supplier<Boolean> runDatapackColors = () -> ((CommonConfig.ConfigMode)((Object)((Object)CommonConfig.CONFIG.colorConfigMode.get()))).hasDatapack() && datapackColorList != null && datapackColorList.size() == MapColor.MATERIAL_COLORS.length;
    public static final Supplier<Boolean> runOverrideColors = () -> ((CommonConfig.ConfigMode)((Object)((Object)CommonConfig.CONFIG.colorConfigMode.get()))).hasCSV() && overridingColorList != null && overridingColorList.size() == MapColor.MATERIAL_COLORS.length;

    @Nullable
    public static @Nullable List<@Nullable Color> getConfigColorList() {
        return configColorList;
    }

    @Nullable
    public static @Nullable List<@Nullable Color> configColorList() {
        return configColorList;
    }

    public static void setConfigColorList(@Nullable @Nullable List<@Nullable Color> configColorList) {
        ColorListManager.configColorList = configColorList;
        ColorListManager.reloadMapColorList();
    }

    @Nullable
    public static @Nullable List<@Nullable Color> getDatapackColorList() {
        return datapackColorList;
    }

    @Nullable
    public static @Nullable List<@Nullable Color> datapackColorList() {
        return datapackColorList;
    }

    public static void setDatapackColorList(@Nullable @Nullable List<@Nullable Color> datapackColorList) {
        ColorListManager.datapackColorList = datapackColorList;
        ColorListManager.reloadMapColorList();
    }

    @Nullable
    public static @Nullable List<@Nullable Color> getOverridingColorList() {
        return overridingColorList;
    }

    @Nullable
    public static @Nullable List<@Nullable Color> overridingColorList() {
        return overridingColorList;
    }

    public static void setOverridingColorList(@Nullable @Nullable List<@Nullable Color> please) {
        overridingColorList = please != null ? new ArrayList<Color>(please) : new ArrayList();
        ColorListManager.reloadMapColorList();
    }

    public static void onDisconnect() {
        serverColors = null;
        ColorListManager.reloadMapColorList();
    }

    public static void handleSyncPayload(ColorListSyncPayload payload) {
        serverColors = Arrays.copyOf(payload.colors(), payload.colors().length);
        ColorListManager.reloadMapColorList();
    }

    private static void reloadMapColorList() {
        int i;
        ColorListManager.ensureListsExist();
        for (i = 0; i < MapColor.MATERIAL_COLORS.length; ++i) {
            MapColor c = MapColor.MATERIAL_COLORS[i];
            if (c == null) {
                c = new MapColor(i, 0);
            }
            if (runOverrideColors.get().booleanValue() && ColorListManager.setMapColorFrom(c, Objects.requireNonNull(overridingColorList)) || runDatapackColors.get().booleanValue() && ColorListManager.setMapColorFrom(c, Objects.requireNonNull(datapackColorList)) || !runConfigColors.get().booleanValue()) continue;
            ColorListManager.setMapColorFrom(c, Objects.requireNonNull(configColorList));
        }
        if (serverColors != null) {
            for (i = 0; i < serverColors.length; ++i) {
                Color serverColor = serverColors[i];
                if (serverColor == null || serverColor.getRGB() == -1) continue;
                MapColor.MATERIAL_COLORS[i].col = serverColor.getRGB();
            }
        }
    }

    private static boolean setMapColorFrom(MapColor c, List<Color> referenceList) {
        Color pc = referenceList.get(c.id);
        if (pc != null) {
            c.col = pc.getRGB();
            return true;
        }
        return false;
    }

    public static Color[] buildSyncList() {
        Color[] list = new Color[MapColor.MATERIAL_COLORS.length];
        ColorListManager.ensureListsExist();
        for (int i = 0; i < list.length; ++i) {
            if (runConfigColors.get().booleanValue()) {
                list[i] = Objects.requireNonNull(configColorList).get(i);
            }
            if (runDatapackColors.get().booleanValue()) {
                list[i] = Objects.requireNonNull(datapackColorList).get(i);
            }
            if (!runOverrideColors.get().booleanValue()) continue;
            list[i] = Objects.requireNonNull(overridingColorList).get(i);
        }
        return list;
    }

    public static void ensureListsExist() {
        if (!((CommonConfig.ConfigMode)((Object)CommonConfig.CONFIG.colorConfigMode.get())).hasCSV()) {
            overridingColorList = new ArrayList<Color>();
        }
        if (!((CommonConfig.ConfigMode)((Object)CommonConfig.CONFIG.colorConfigMode.get())).hasDatapack()) {
            datapackColorList = new ArrayList<Color>();
        }
        if (!((CommonConfig.ConfigMode)((Object)CommonConfig.CONFIG.colorConfigMode.get())).hasModConfig()) {
            configColorList = new ArrayList<Color>();
        }
    }
}

