/*
 * Decompiled with CFR 0.152.
 */
package org.gneisscode.improvedmapcolors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import org.gneisscode.improvedmapcolors.CommonConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorStateMapManager {
    private static @Nullable Map<BlockState, @NotNull BlockStatePropertyTracker> configStateTrackerMap = new HashMap<BlockState, BlockStatePropertyTracker>();
    private static @Nullable Map<BlockState, @NotNull BlockStatePropertyTracker> datapackStateTrackerMap = new HashMap<BlockState, BlockStatePropertyTracker>();
    private static @Nullable Map<BlockState, @NotNull BlockStatePropertyTracker> overridingStateTrackerMap = new HashMap<BlockState, BlockStatePropertyTracker>();
    public static final Supplier<Boolean> runConfigColors = () -> ((CommonConfig.ConfigMode)((Object)((Object)CommonConfig.CONFIG.statesConfigMode.get()))).hasModConfig() && configStateTrackerMap != null;
    public static final Supplier<Boolean> runDatapackColors = () -> ((CommonConfig.ConfigMode)((Object)((Object)CommonConfig.CONFIG.statesConfigMode.get()))).hasDatapack() && datapackStateTrackerMap != null;
    public static final Supplier<Boolean> runOverrideColors = () -> ((CommonConfig.ConfigMode)((Object)((Object)CommonConfig.CONFIG.statesConfigMode.get()))).hasCSV() && overridingStateTrackerMap != null;

    public static @Nullable Map<BlockState, @NotNull BlockStatePropertyTracker> getConfigStateTrackerMap() {
        return configStateTrackerMap;
    }

    public static @Nullable Map<BlockState, @NotNull BlockStatePropertyTracker> configStateTrackerMap() {
        return configStateTrackerMap;
    }

    public static void setConfigStateTrackerMap(@Nullable Map<BlockState, @NotNull BlockStatePropertyTracker> configStateTrackerMap) {
        ColorStateMapManager.configStateTrackerMap = configStateTrackerMap;
    }

    public static @Nullable Map<BlockState, @NotNull BlockStatePropertyTracker> getDatapackStateTrackerMap() {
        return datapackStateTrackerMap;
    }

    public static @Nullable Map<BlockState, @NotNull BlockStatePropertyTracker> datapackStateTrackerMap() {
        return datapackStateTrackerMap;
    }

    public static void setDatapackStateTrackerMap(@Nullable Map<BlockState, @NotNull BlockStatePropertyTracker> datapackStateTrackerMap) {
        ColorStateMapManager.datapackStateTrackerMap = datapackStateTrackerMap;
    }

    public static @Nullable Map<BlockState, @NotNull BlockStatePropertyTracker> getOverridingStateTrackerMap() {
        return overridingStateTrackerMap;
    }

    public static @Nullable Map<BlockState, @NotNull BlockStatePropertyTracker> overridingStateTrackerMap() {
        return overridingStateTrackerMap;
    }

    public static void setOverridingStateTrackerMap(@Nullable Map<BlockState, @NotNull BlockStatePropertyTracker> overridingStateTrackerMap) {
        ColorStateMapManager.overridingStateTrackerMap = overridingStateTrackerMap;
    }

    public static MapColor getMapColorFromBlockState(BlockState instance, MapColor m) {
        int color = ColorStateMapManager.getColorIDFromState(instance);
        if (color != -1) {
            m = MapColor.MATERIAL_COLORS[color];
        }
        return m;
    }

    public static void unloadStateColors() {
        if (!((CommonConfig.ConfigMode)((Object)CommonConfig.CONFIG.statesConfigMode.get())).hasCSV()) {
            overridingStateTrackerMap = new HashMap<BlockState, BlockStatePropertyTracker>();
        }
        if (!((CommonConfig.ConfigMode)((Object)CommonConfig.CONFIG.statesConfigMode.get())).hasDatapack()) {
            datapackStateTrackerMap = new HashMap<BlockState, BlockStatePropertyTracker>();
        }
        if (!((CommonConfig.ConfigMode)((Object)CommonConfig.CONFIG.statesConfigMode.get())).hasModConfig()) {
            configStateTrackerMap = new HashMap<BlockState, BlockStatePropertyTracker>();
        }
    }

    public static int getColorIDFromState(BlockState instance) {
        int tempColorID = -1;
        if (runOverrideColors.get().booleanValue()) {
            tempColorID = ColorStateMapManager.getColorIDFromMap(instance, Objects.requireNonNull(overridingStateTrackerMap));
        }
        if (tempColorID == -1 && runDatapackColors.get().booleanValue()) {
            tempColorID = ColorStateMapManager.getColorIDFromMap(instance, Objects.requireNonNull(datapackStateTrackerMap));
        }
        if (tempColorID == -1 && runConfigColors.get().booleanValue()) {
            tempColorID = ColorStateMapManager.getColorIDFromMap(instance, Objects.requireNonNull(configStateTrackerMap));
        }
        return tempColorID;
    }

    private static int getColorIDFromMap(BlockState instance, Map<BlockState, BlockStatePropertyTracker> targetMap) {
        Block owner = instance.getBlock();
        BlockState defaultState = owner.defaultBlockState();
        BlockStatePropertyTracker defaultTracker = targetMap.getOrDefault(instance, BlockStatePropertyTracker.DEFAULT);
        HashMap<Property<?>, Boolean> hasPropertyMap = instance.equals((Object)defaultState) && defaultTracker.trackedProperties != null && !defaultTracker.trackedProperties.isEmpty() ? ColorStateMapManager.populateHasPropertyMapFromValueStateMap(defaultState, defaultTracker.trackedProperties) : ColorStateMapManager.populateHasPropertyMap(instance, defaultState);
        if (hasPropertyMap.values().stream().noneMatch(b -> b)) {
            return targetMap.getOrDefault((Object)defaultState, (BlockStatePropertyTracker)BlockStatePropertyTracker.DEFAULT).colorID;
        }
        Set<BlockState> keys = targetMap.keySet();
        ArrayList<BlockState> stateMatches = ColorStateMapManager.collectStateMatches(instance, keys, owner, hasPropertyMap, targetMap);
        if (stateMatches.isEmpty()) {
            return -1;
        }
        stateMatches.sort(ColorStateMapManager::compareStateValues);
        return targetMap.getOrDefault(stateMatches.getFirst(), (BlockStatePropertyTracker)BlockStatePropertyTracker.DEFAULT).colorID;
    }

    private static HashMap<Property<?>, Boolean> populateHasPropertyMapFromValueStateMap(BlockState defaultState, List<String> strings) {
        HashMap hasPropertyMap = new HashMap();
        for (Property p : defaultState.getProperties()) {
            if (strings.contains(p.getName())) {
                hasPropertyMap.put(p, Boolean.TRUE);
                continue;
            }
            hasPropertyMap.put(p, Boolean.FALSE);
        }
        return hasPropertyMap;
    }

    private static HashMap<Property<?>, Boolean> populateHasPropertyMap(BlockState instance, BlockState defaultState) {
        HashMap hasPropertyMap = new HashMap();
        for (Property p : instance.getProperties()) {
            if (instance.getValue(p).equals(defaultState.getValue(p))) {
                hasPropertyMap.put(p, Boolean.FALSE);
                continue;
            }
            hasPropertyMap.put(p, Boolean.TRUE);
        }
        return hasPropertyMap;
    }

    private static ArrayList<BlockState> collectStateMatches(BlockState instance, Set<BlockState> keys, Block owner, HashMap<Property<?>, Boolean> hasProperty, Map<BlockState, BlockStatePropertyTracker> targetMap) {
        ArrayList<BlockState> stateMatches = new ArrayList<BlockState>();
        for (BlockState state : keys) {
            if (state.getBlock() != owner) continue;
            List<String> definedStateProperties = targetMap.getOrDefault((Object)state, (BlockStatePropertyTracker)BlockStatePropertyTracker.DEFAULT).trackedProperties;
            if (definedStateProperties == null) {
                stateMatches.add(state);
                continue;
            }
            boolean matches = true;
            for (Property otherP : state.getProperties()) {
                if (!hasProperty.containsKey(otherP) || state.getValue(otherP).equals(instance.getValue(otherP)) || !definedStateProperties.contains(otherP.getName())) continue;
                matches = false;
            }
            if (!matches) continue;
            stateMatches.add(state);
        }
        return stateMatches;
    }

    public static int getNumChangedProperties(BlockState state) {
        BlockState defaultState = state.getBlock().defaultBlockState();
        int numChanged = 0;
        for (Property p : state.getProperties()) {
            if (!state.getValue(p).equals(defaultState.getValue(p))) continue;
            ++numChanged;
        }
        return numChanged;
    }

    public static int compareStateValues(BlockState state1, BlockState state2) {
        int state1Changed = ColorStateMapManager.getNumChangedProperties(state1);
        int state2Changed = ColorStateMapManager.getNumChangedProperties(state2);
        return Integer.compare(state1Changed, state2Changed);
    }

    public static boolean blockStatesEqual(BlockState s1, BlockState s2) {
        for (Property p : s1.getProperties()) {
            if (!s2.hasProperty(p)) {
                return false;
            }
            if (s1.getValue(p).equals(s2.getValue(p))) continue;
            return false;
        }
        return true;
    }

    public record BlockStatePropertyTracker(BlockState state, int colorID, @Nullable List<String> trackedProperties) {
        public static final Codec<BlockStatePropertyTracker> PROPERTY_TRACKER_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.CODEC.fieldOf("state").forGetter(BlockStatePropertyTracker::state), (App)Codec.intRange((int)0, (int)63).fieldOf("colorID").forGetter(BlockStatePropertyTracker::colorID), (App)Codec.list((Codec)Codec.STRING).optionalFieldOf("trackedProperties").forGetter(inst -> inst.trackedProperties() == null ? Optional.empty() : Optional.of(inst.trackedProperties()))).apply((Applicative)instance, (state, id, op) -> new BlockStatePropertyTracker((BlockState)state, (int)id, op.orElse(null))));
        public static final BlockStatePropertyTracker DEFAULT = new BlockStatePropertyTracker(Blocks.AIR.defaultBlockState(), -1, null);

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            List<String> list;
            int n;
            BlockState state1;
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof BlockStatePropertyTracker)) return false;
            BlockStatePropertyTracker blockStatePropertyTracker = (BlockStatePropertyTracker)obj;
            try {
                BlockState blockState;
                state1 = blockState = blockStatePropertyTracker.state();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            int id = n = blockStatePropertyTracker.colorID();
            List<String> properties = list = blockStatePropertyTracker.trackedProperties();
            if (this.colorID != id) {
                return false;
            }
            if (this.trackedProperties == null != (properties == null)) {
                return false;
            }
            if (this.trackedProperties == null || this.trackedProperties.equals(properties)) return ColorStateMapManager.blockStatesEqual(this.state, state1);
            return false;
        }
    }
}

