/*
 * Decompiled with CFR 0.152.
 */
package org.gneisscode.improvedmapcolors;

import com.electronwill.nightconfig.core.EnumGetMethod;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import com.opencsv.CSVReader;
import com.opencsv.exceptions.CsvException;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import org.gneisscode.improvedmapcolors.ColorListManager;
import org.gneisscode.improvedmapcolors.ColorStateMapManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonConfig {
    public static final CommonConfig CONFIG;
    public static final ModConfigSpec CONFIG_SPEC;
    public final ModConfigSpec.ConfigValue<List<? extends String>> configColorList;
    public final ModConfigSpec.EnumValue<ConfigMode> colorConfigMode;
    public final ModConfigSpec.ConfigValue<String> colorCsvPath;
    public final ModConfigSpec.ConfigValue<List<? extends String>> configBlockStateList;
    public final ModConfigSpec.EnumValue<ConfigMode> statesConfigMode;
    public final ModConfigSpec.ConfigValue<String> blockStateCsvPath;
    public static final ArrayList<String> defaultStateList;
    public static final ArrayList<String> defaultColorList;

    private CommonConfig(ModConfigSpec.Builder builder) {
        this.configColorList = builder.comment("List of colors to replace vanilla map colors, defaulting to Vanilla colors (gneiss colors)").defineList("colorlist", defaultColorList, String::new, CommonConfig::validateColor);
        this.colorConfigMode = builder.comment("What mode to use when loading color values").comment("Config values will override a datapack, and CSV values will override both datapacks and the config").defineEnum("colorConfigMode", (Enum)ConfigMode.CONFIG_DATAPACK, EnumGetMethod.NAME_IGNORECASE, (Collection)Lists.newArrayList((Object[])new ConfigMode[]{ConfigMode.CONFIG_DATAPACK, ConfigMode.ALL, ConfigMode.CONFIG, ConfigMode.DATAPACK, ConfigMode.CSV_FILE}));
        this.colorCsvPath = builder.comment("Path to a CSV list of colors like: |hex color|[optional id]|").comment("If no ID is supplied, the id will be the column number in the file").define("color_file", (Object)"", CommonConfig::fileValidator);
        this.configBlockStateList = builder.comment("List of BlockStates:ColorID to change from Vanilla BlockStates (will default to Gneiss states)").defineList("state_list", defaultStateList, String::new, CommonConfig::validateBlockStateListEntry);
        this.statesConfigMode = builder.comment("What mode to use when loading BlockState values").comment("On conflicts, config values will override datapacks', and CSV values will override both datapacks and the config").defineEnum("statesConfigMode", (Enum)ConfigMode.CONFIG_DATAPACK, EnumGetMethod.NAME_IGNORECASE, (Collection)Lists.newArrayList((Object[])new ConfigMode[]{ConfigMode.CONFIG_DATAPACK, ConfigMode.ALL, ConfigMode.CONFIG, ConfigMode.DATAPACK, ConfigMode.CSV_FILE}));
        this.blockStateCsvPath = builder.comment("Path to a CSV list of states like:").comment("|BlockID[statedata]|colorID<required>| OR:").comment("|BlockID|[statedata]|colorID<required>|").define("blockstate_file", (Object)"", CommonConfig::fileValidator);
    }

    public static boolean validateColor(Object o) {
        if (!(o instanceof String)) {
            return false;
        }
        String s = (String)o;
        if (s.isEmpty()) {
            return true;
        }
        try {
            Color.decode(s);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static boolean fileValidator(Object o) {
        if (!(o instanceof String)) {
            return false;
        }
        String s = (String)o;
        if (s.isEmpty()) {
            return true;
        }
        s = s.replace("\"", "");
        Path p = null;
        try {
            p = Paths.get(s, new String[0]);
        }
        catch (NullPointerException | InvalidPathException ex) {
            return false;
        }
        File f = p.toFile();
        return f.exists() && f.isFile() && (s.endsWith(".csv") || s.endsWith(".json"));
    }

    public static boolean zipFileValidator(String s) {
        if (s.isEmpty()) {
            return true;
        }
        Path p = null;
        try {
            p = Paths.get(s, new String[0]);
        }
        catch (NullPointerException | InvalidPathException ex) {
            return false;
        }
        File f = p.toFile();
        return s.endsWith(".zip");
    }

    public static boolean validateBlockStateListEntry(Object o) {
        if (!(o instanceof String)) {
            return false;
        }
        String s = (String)o;
        return s.contains(":");
    }

    public static void initIndexIdColorList() {
        if (((ConfigMode)((Object)CommonConfig.CONFIG.colorConfigMode.get())).hasModConfig()) {
            List<@Nullable Color> colorList = ((List)CommonConfig.CONFIG.configColorList.get()).stream().map(string -> string.isEmpty() ? null : Color.decode(string)).collect(Collectors.toList());
            int offset = colorList.size();
            int runs = MapColor.MATERIAL_COLORS.length - colorList.size();
            for (int i = 0; i < runs; ++i) {
                colorList.add(offset + i, null);
            }
            ColorListManager.setConfigColorList(colorList);
        }
        if (((ConfigMode)((Object)CommonConfig.CONFIG.colorConfigMode.get())).hasCSV()) {
            List<@Nullable Color> overrideList = CommonConfig.loadColorListCSV();
            ColorListManager.setOverridingColorList(overrideList);
        }
    }

    @Nullable
    public static @Nullable List<@Nullable Color> loadColorListCSV() {
        int i;
        Path p = null;
        try {
            p = Paths.get(((String)CommonConfig.CONFIG.colorCsvPath.get()).replace("\"", ""), new String[0]);
        }
        catch (NullPointerException | InvalidPathException ex) {
            return null;
        }
        File f = p.toFile();
        BufferedReader reader = null;
        try {
            reader = Files.newBufferedReader(p);
        }
        catch (IOException e) {
            LogUtils.getLogger().error("CSV could not be found!");
            return null;
        }
        CSVReader csvReader = new CSVReader((Reader)reader);
        List entries = null;
        try {
            entries = csvReader.readAll();
        }
        catch (CsvException | IOException e) {
            LogUtils.getLogger().error("CSV Could not be read!");
            return null;
        }
        ArrayList<@Nullable Color> colors = new ArrayList<Color>(MapColor.MATERIAL_COLORS.length);
        for (i = 0; i < MapColor.MATERIAL_COLORS.length; ++i) {
            colors.add(null);
        }
        for (i = 0; i < entries.size(); ++i) {
            Color c;
            int realLength;
            String[] entry;
            block15: {
                entry = (String[])entries.get(i);
                realLength = Math.toIntExact(Arrays.stream(entry).filter(Predicate.not(String::isEmpty)).count());
                c = null;
                if (realLength != 4) {
                    try {
                        c = Color.decode(entry[0]);
                        break block15;
                    }
                    catch (NumberFormatException ignored) {
                        continue;
                    }
                }
                c = new Color(Integer.parseInt(entry[1]), Integer.parseInt(entry[2]), Integer.parseInt(entry[3]));
            }
            if (realLength == 4) {
                colors.set(Integer.parseInt(entry[0]), c);
                continue;
            }
            if (realLength == 1) {
                colors.set(i, c);
                continue;
            }
            try {
                colors.set(Integer.parseInt(entry[1]), c);
                continue;
            }
            catch (NumberFormatException nfe) {
                colors.set(i, c);
            }
        }
        return colors;
    }

    public static void loadColorList() {
        CommonConfig.initIndexIdColorList();
    }

    public static void loadBlockStateList() {
        if (((ConfigMode)((Object)CommonConfig.CONFIG.statesConfigMode.get())).hasCSV()) {
            ColorStateMapManager.setOverridingStateTrackerMap(CommonConfig.parseBlockStateDataCSV());
        }
        if (((ConfigMode)((Object)CommonConfig.CONFIG.statesConfigMode.get())).hasModConfig()) {
            ColorStateMapManager.setConfigStateTrackerMap(CommonConfig.loadBlockStateListFromConfig());
        }
    }

    @NotNull
    public static Map<BlockState, ColorStateMapManager.BlockStatePropertyTracker> loadBlockStateListFromConfig() {
        HashMap<BlockState, ColorStateMapManager.BlockStatePropertyTracker> stateColorMap = new HashMap<BlockState, ColorStateMapManager.BlockStatePropertyTracker>();
        for (String s : (List)CommonConfig.CONFIG.configBlockStateList.get()) {
            String[] split;
            if (s.isEmpty() || (split = s.split(":")).length < 2) continue;
            boolean hasNamespace = split.length == 3;
            int colorID = -1;
            try {
                colorID = hasNamespace ? Integer.parseInt(split[2]) : Integer.parseInt(split[1]);
            }
            catch (NumberFormatException nfe) {
                LogUtils.getLogger().error(nfe.getLocalizedMessage());
                continue;
            }
            String[] pathAndState = (hasNamespace ? split[1] : split[0]).split("\\[");
            String blockStateData = pathAndState.length < 2 ? null : pathAndState[1].replace("]", "");
            String path = pathAndState[0];
            ArrayList<String> stateStrings = new ArrayList<String>();
            BlockState state = CommonConfig.parseBlockStateData(blockStateData, path, hasNamespace ? split[0] : null, stateStrings);
            if (state.getBlock() == Blocks.AIR && !path.contains("air")) continue;
            stateColorMap.put(state, new ColorStateMapManager.BlockStatePropertyTracker(state, colorID, stateStrings));
        }
        return stateColorMap;
    }

    public static @Nullable Map<BlockState, @NotNull ColorStateMapManager.BlockStatePropertyTracker> parseBlockStateDataCSV() {
        Path p = null;
        try {
            p = Paths.get(((String)CommonConfig.CONFIG.blockStateCsvPath.get()).replace("\"", ""), new String[0]);
        }
        catch (NullPointerException | InvalidPathException ex) {
            LogUtils.getLogger().error("CSV State Path invalid!");
            return null;
        }
        File f = p.toFile();
        BufferedReader reader = null;
        try {
            reader = Files.newBufferedReader(p);
        }
        catch (IOException e) {
            LogUtils.getLogger().error("CSV State File could not be found!");
            return null;
        }
        CSVReader csvReader = new CSVReader((Reader)reader);
        List entries = null;
        try {
            entries = csvReader.readAll();
        }
        catch (CsvException | IOException e) {
            LogUtils.getLogger().error("CSV State File could not be read!");
            return null;
        }
        HashMap<BlockState, ColorStateMapManager.BlockStatePropertyTracker> stateColorMap = new HashMap<BlockState, ColorStateMapManager.BlockStatePropertyTracker>();
        for (String[] entry : entries) {
            int colorID;
            String id = entry[0];
            int realLength = Math.toIntExact(Arrays.stream(entry).filter(s -> !s.isEmpty()).count());
            String path = null;
            String namespace = null;
            if (id.contains(":")) {
                namespace = id.split(":")[0];
                path = id.split(":")[1];
            } else {
                path = id;
            }
            String blockStateData = null;
            if (realLength == 2) {
                String[] pathAndState = path.split("\\[");
                blockStateData = pathAndState.length < 2 ? null : pathAndState[1].replace("]", "");
                path = pathAndState[0];
            } else {
                if (realLength != 3) continue;
                blockStateData = entry[1].replace("[", "").replace("]", "");
            }
            ArrayList<String> stateStrings = new ArrayList<String>();
            BlockState state = CommonConfig.parseBlockStateData(blockStateData, path, namespace, stateStrings);
            if (state.getBlock() == Blocks.AIR && !path.contains("air")) continue;
            try {
                colorID = Integer.parseInt(realLength == 2 ? entry[1] : entry[2]);
            }
            catch (NumberFormatException e) {
                LogUtils.getLogger().error("colorID in state CSV Malformed!");
                continue;
            }
            stateColorMap.put(state, new ColorStateMapManager.BlockStatePropertyTracker(state, colorID, stateStrings));
        }
        return stateColorMap;
    }

    @NotNull
    public static BlockState parseBlockStateData(@Nullable String blockStateData, String path, @Nullable String namespace, ArrayList<String> stateStrings) {
        boolean hasNamespace = namespace != null;
        ResourceLocation ownerID = hasNamespace ? ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path) : ResourceLocation.withDefaultNamespace((String)path);
        Block owner = (Block)BuiltInRegistries.BLOCK.getValue(ownerID);
        if (owner == Blocks.AIR || blockStateData == null) {
            return owner.defaultBlockState();
        }
        String[] states = blockStateData.split(",");
        BlockState defaultState = owner.defaultBlockState();
        for (String state : states) {
            String name = String.valueOf(state.subSequence(0, state.indexOf("="))).replace("=", "");
            String value = String.valueOf(state.substring(state.indexOf("="))).replace("=", "");
            Property prop = owner.getStateDefinition().getProperty(name);
            if (prop == null) continue;
            defaultState = CommonConfig.setProperty(defaultState, prop, value);
            stateStrings.add(name);
        }
        return defaultState;
    }

    public static <T extends Comparable<T>> BlockState setProperty(BlockState state, Property<T> property, String value) {
        Optional val = property.getValue(value);
        return val.map(t -> (BlockState)state.setValue(property, t)).orElse(state);
    }

    public static void reloadConfig() {
        LogUtils.getLogger().info("Reloading Config!");
        CommonConfig.loadColorList();
        CommonConfig.loadBlockStateList();
    }

    static {
        defaultStateList = Lists.newArrayList((Object[])new String[]{"minecraft:mushroom_stem[up=false]:2", "minecraft:brown_mushroom_block[up=false]:2", "minecraft:red_mushroom_block[up=false]:2", "minecraft:packed_mud:44", "minecraft:jukebox:34", "minecraft:note_block:48", "minecraft:jungle_wood:34", "minecraft:birch_wood:14", "minecraft:oak_wood:34", "minecraft:spruce_wood:26", "minecraft:acacia_wood:11", "minecraft:crimson_stem[axis=x]:54", "minecraft:crimson_stem[axis=z]:54", "minecraft:warped_stem[axis=x]:57", "minecraft:warped_stem[axis=z]:57", "minecraft:stripped_warped_hyphae:56", "minecraft:stripped_crimson_hyphae:53", "minecraft:bamboo_block:7", "minecraft:mangrove_wood:34", "minecraft:barrel:34", "minecraft:cartography_table:26", "minecraft:fletching_table:2", "minecraft:composter:15", "minecraft:noteblock:34", "minecraft:daylight_detector:26", "minecraft:smithing_table:21", "minecraft:white_candle:8", "minecraft:rail:6", "minecraft:powered_rail:6", "minecraft:detector_rail:6", "minecraft:activator_rail:6", "minecraft:sticky_piston[facing=up]:61", "minecraft:piston[facing=up]:13", "minecraft:test_block[mode=accept]:1", "minecraft:test_block[mode=fail]:39", "minecraft:test_block[mode=log]:5", "minecraft:test_block[mode=start]:60", "minecraft:pink_petals:36", "minecraft:short_grass:0", "minecraft:poppy:28", "minecraft:allium:16", "minecraft:azure_bluet:2", "minecraft:blue_orchid:17", "minecraft:dandelion:18", "minecraft:lily_of_the_valley:8", "minecraft:oxeye_daisy:22", "minecraft:torchflower:40", "minecraft:orange_tulip:15", "minecraft:red_tulip:52", "minecraft:white_tulip:14", "minecraft:pink_tulip:16", "minecraft:wither_rose:21", "minecraft:short_grass:0", "minecraft:wildflowers:18", "minecraft:cornflower:25", "minecraft:pitcher_plant:23", "minecraft:sea_pickle:19", "minecraft:pink_petals:36", "minecraft:lilac:16", "minecraft:rose_bush:28", "minecraft:peony:20", "minecraft:sunflower:18"});
        defaultColorList = Lists.newArrayList((Object[])new String[]{"#000000", "#7fb238", "#f7e9a3", "#c7c7c7", "#ff0000", "#a0a0ff", "#a7a7a7", "#007c00", "#ffffff", "#a4a8b8", "#976d4d", "#707070", "#4040ff", "#8f7748", "#fffcf5", "#d87f33", "#b24cd8", "#6699d8", "#e5e533", "#7fcc19", "#f27fa5", "#4c4c4c", "#999999", "#4c7f99", "#7f3fb2", "#334cb2", "#664c33", "#667f33", "#993333", "#191919", "#faee4d", "#5cdbd5", "#4a80ff", "#00d93a", "#815631", "#700200", "#d1b1a1", "#9f5224", "#95576c", "#706c8a", "#ba8524", "#677535", "#a04d4e", "#392923", "#876b62", "#575c5c", "#7a4958", "#4c3e5c", "#4c3223", "#4c522a", "#8e3c2e", "#251610", "#bd3031", "#943f61", "#5c191d", "#167e86", "#3a8e8c", "#562c3e", "#14b485", "#646464", "#d8af93", "#7fa796"});
        Pair configPair = new ModConfigSpec.Builder().configure(CommonConfig::new);
        CONFIG = (CommonConfig)configPair.getLeft();
        CONFIG_SPEC = (ModConfigSpec)configPair.getRight();
    }

    public static enum ConfigMode {
        CONFIG(1),
        DATAPACK(2),
        CSV_FILE(4),
        CONFIG_DATAPACK(3),
        CONFIG_CSV(5),
        CSV_DATAPACK(6),
        ALL(7);

        public final byte mode;

        private ConfigMode(int fileFlag) {
            this.mode = (byte)fileFlag;
        }

        public boolean hasCSV() {
            return (this.mode & 4) == 4;
        }

        public boolean hasModConfig() {
            return (this.mode & 1) == 1;
        }

        public boolean hasDatapack() {
            return (this.mode & 2) == 2;
        }

        public boolean hasModConfigOrCSV() {
            return (this.mode & 6) != 0;
        }
    }
}

