/*
 * Decompiled with CFR 0.152.
 */
package org.gneisscode.improvedmapcolors;

import com.google.common.base.Suppliers;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.gneisscode.improvedmapcolors.Commands;
import org.gneisscode.improvedmapcolors.MapColorBlock;
import org.gneisscode.improvedmapcolors.MapColorBlockItem;
import org.gneisscode.improvedmapcolors.PresetManager;
import org.gneisscode.improvedmapcolors.SyncColors;

public final class ImprovedMapColors {
    public static final String MOD_ID = "improvedmapcolors";
    public static final ResourceLocation COLOR_LIST_SYNC_PAYLOAD_ID = ResourceLocation.fromNamespaceAndPath((String)"improvedmapcolors", (String)"color_list_sync_payload");
    public static final ResourceLocation CHOOSE_PRESET_PAYLOAD_ID = ImprovedMapColors.resource("choose_preset_payload");
    public static final ResourceLocation SYNC_PRESET_PAYLOAD_ID = ImprovedMapColors.resource("sync_preset_payload");
    public static final Supplier<RegistrarManager> MANAGER = Suppliers.memoize(() -> RegistrarManager.get((String)MOD_ID));
    public static final Registrar<Block> BLOCKS = MANAGER.get().get(Registries.BLOCK);
    public static final Registrar<Item> ITEMS = MANAGER.get().get(Registries.ITEM);
    public static ResourceKey<Block> MAP_BLOCK_KEY = ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"improvedmapcolors", (String)"map_color_block"));
    public static final RegistrySupplier<Block> MAP_BLOCK = BLOCKS.register(ResourceLocation.fromNamespaceAndPath((String)"improvedmapcolors", (String)"map_color_block"), () -> new MapColorBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BARRIER).mapColor(MapColorBlock.getMapColorFunction()).setId(MAP_BLOCK_KEY)));
    public static ResourceKey<Item> MAP_BLOCK_ITEM_KEY = ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"improvedmapcolors", (String)"map_block_item"));
    public static final RegistrySupplier<Item> MAP_BLOCK_ITEM = ITEMS.register(ResourceLocation.fromNamespaceAndPath((String)"improvedmapcolors", (String)"map_block_item"), () -> new MapColorBlockItem((Block)MAP_BLOCK.get(), new Item.Properties().rarity(Rarity.EPIC).setId(MAP_BLOCK_ITEM_KEY)));

    public static void init() {
        PlayerEvent.PLAYER_JOIN.register(SyncColors::syncColors);
        PlayerEvent.PLAYER_JOIN.register(PresetManager::syncPresetOnPlayerJoin);
        LifecycleEvent.SERVER_LEVEL_LOAD.register(PresetManager::checkAndEnsurePresetPackLoaded);
        CommandRegistrationEvent.EVENT.register(Commands::registerCommands);
    }

    public static ResourceLocation resource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

