/*
 * Decompiled with CFR 0.152.
 */
package org.gneisscode.improvedmapcolors;

import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MapColorBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final IntegerProperty MAP_COLOR = IntegerProperty.create((String)"map_color", (int)1, (int)64);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public MapColorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)MAP_COLOR, (Comparable)Integer.valueOf(1))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public static Function<BlockState, MapColor> getMapColorFunction() {
        return state -> MapColor.MATERIAL_COLORS[(Integer)state.getValue((Property)MAP_COLOR) - 1];
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{MAP_COLOR}).add(new Property[]{WATERLOGGED});
    }

    protected boolean propagatesSkylightDown(BlockState arg) {
        return arg.getFluidState().isEmpty();
    }

    @NotNull
    protected RenderShape getRenderShape(BlockState arg) {
        return RenderShape.INVISIBLE;
    }

    protected float getShadeBrightness(BlockState arg, BlockGetter arg2, BlockPos arg3) {
        return 1.0f;
    }

    @NotNull
    protected BlockState updateShape(BlockState arg, LevelReader arg2, ScheduledTickAccess arg3, BlockPos arg4, Direction arg5, BlockPos arg6, BlockState arg7, RandomSource arg8) {
        if (((Boolean)arg.getValue((Property)WATERLOGGED)).booleanValue()) {
            arg3.scheduleTick(arg4, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(arg2));
        }
        return super.updateShape(arg, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    }

    @NotNull
    protected FluidState getFluidState(BlockState arg) {
        return (Boolean)arg.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(arg);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext arg) {
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(arg.getLevel().getFluidState(arg.getClickedPos()).getType() == Fluids.WATER));
    }

    @NotNull
    public ItemStack pickupBlock(@Nullable LivingEntity arg, LevelAccessor arg2, BlockPos arg3, BlockState arg4) {
        Player player;
        return arg instanceof Player && (player = (Player)arg).isCreative() ? super.pickupBlock(arg, arg2, arg3, arg4) : ItemStack.EMPTY;
    }

    public boolean canPlaceLiquid(@Nullable LivingEntity arg, BlockGetter arg2, BlockPos arg3, BlockState arg4, Fluid arg5) {
        Player player;
        return arg instanceof Player && (player = (Player)arg).isCreative() && super.canPlaceLiquid(arg, arg2, arg3, arg4, arg5);
    }

    protected ItemStack getCloneItemStack(LevelReader levelReader, BlockPos blockPos, BlockState blockState, boolean bl) {
        return MapColorBlock.setLightOnStack(super.getCloneItemStack(levelReader, blockPos, blockState, bl), (Integer)blockState.getValue((Property)MAP_COLOR));
    }

    public static ItemStack setLightOnStack(ItemStack itemStack, int i) {
        itemStack.set(DataComponents.BLOCK_STATE, (Object)BlockItemStateProperties.EMPTY.with((Property)MAP_COLOR, (Comparable)Integer.valueOf(i)));
        return itemStack;
    }

    private static void message(Player player, Component component) {
        ((ServerPlayer)player).sendSystemMessage(component, true);
    }
}

