/*
 * Decompiled with CFR 0.152.
 */
package org.gneisscode.improvedmapcolors;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.gneisscode.improvedmapcolors.ImprovedMapColors;
import org.gneisscode.improvedmapcolors.MapColorBlock;

public class MapColorBlockItem
extends BlockItem {
    public MapColorBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, TooltipDisplay tooltipDisplay, Consumer<Component> consumer, TooltipFlag tooltipFlag) {
        consumer.accept((Component)Component.translatable((String)"item.improvedmapcolors.map_block_item.tooltip", (Object[])new Object[]{Component.keybind((String)"key.use"), Component.keybind((String)"key.use"), Component.keybind((String)"key.sneak")}));
        super.appendHoverText(itemStack, tooltipContext, tooltipDisplay, consumer, tooltipFlag);
    }

    public InteractionResult useOn(UseOnContext useOnContext) {
        BlockPos blockPos;
        Player player = useOnContext.getPlayer();
        Level level = useOnContext.getLevel();
        BlockState blockState = level.getBlockState(blockPos = useOnContext.getClickedPos());
        if (blockState.getBlock() != ImprovedMapColors.MAP_BLOCK.get()) {
            return super.useOn(useOnContext);
        }
        if (!level.isClientSide && player != null && player.canUseGameMasterBlocks()) {
            BlockState nextState = MapColorBlockItem.cycleState(blockState, player.isSecondaryUseActive());
            level.setBlock(blockPos, nextState, 2);
            MapColorBlockItem.message(player, (Component)Component.translatable((String)"item.improvedmapcolors.map_block_item.update_color", (Object[])new Object[]{(Integer)blockState.getValue((Property)MapColorBlock.MAP_COLOR) - 1, (Integer)nextState.getValue((Property)MapColorBlock.MAP_COLOR) - 1}));
            return InteractionResult.SUCCESS_SERVER;
        }
        return InteractionResult.CONSUME;
    }

    private static BlockState cycleState(BlockState blockState, boolean bl) {
        return (BlockState)blockState.setValue((Property)MapColorBlock.MAP_COLOR, (Comparable)Integer.valueOf(MapColorBlockItem.getRelative(MapColorBlock.MAP_COLOR.getPossibleValues(), (Integer)blockState.getValue((Property)MapColorBlock.MAP_COLOR), bl)));
    }

    private static int getRelative(List<Integer> iterable, Integer object, boolean bl) {
        if (object.equals(iterable.getFirst()) && bl) {
            return object;
        }
        return bl ? ((Integer)Util.findPreviousInIterable(iterable, (Object)object)).intValue() : ((Integer)Util.findNextInIterable(iterable, (Object)object)).intValue();
    }

    private static void message(Player player, Component component) {
        ((ServerPlayer)player).sendSystemMessage(component, true);
    }
}

