/*
 * Decompiled with CFR 0.152.
 */
package org.gneisscode.improvedmapcolors;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import dev.architectury.injectables.annotations.ExpectPlatform;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.LevelResource;
import org.gneisscode.improvedmapcolors.ImprovedMapColors;
import org.gneisscode.improvedmapcolors.neoforge.PresetManagerImpl;
import org.gneisscode.improvedmapcolors.networking.SelectPresetC2SPayload;
import org.gneisscode.improvedmapcolors.presets.PresetDataContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class PresetManager {
    public static StreamCodec<RegistryFriendlyByteBuf, Preset> PRESET_PACKET_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, Preset::getSerializedName, Preset::getFromSeiralizedName);
    public static StreamCodec<ByteBuf, Preset> NEO_PRESET_PACKET_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, Preset::getSerializedName, Preset::getFromSeiralizedName);
    public static final Map<Preset, Resource> packDefaults = new HashMap<Preset, Resource>();
    public static final Preset DEFAULT = Preset.VANILLA;
    @Nullable
    public static Preset selectedPreset = null;

    public static void addPack(Preset p, Resource r) {
        packDefaults.put(p, r);
    }

    public static void clearPackDefaults() {
        packDefaults.clear();
    }

    public static void loadPreset(CompoundTag worldData) {
    }

    public static String getSelectedPresetName() {
        return Objects.requireNonNullElse(selectedPreset, DEFAULT).getSerializedName();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void setAndSendSelectedPreset(Preset preset) {
        PresetManagerImpl.setAndSendSelectedPreset(preset);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void syncPresetOnPlayerJoin(ServerPlayer p) {
        PresetManagerImpl.syncPresetOnPlayerJoin(p);
    }

    public static Preset getServerPreset(MinecraftServer server) {
        if (server == null) {
            return selectedPreset;
        }
        for (ServerLevel l : server.getAllLevels()) {
            LevelData levelData = l.getLevelData();
            if (!(levelData instanceof PresetDataContainer)) continue;
            PresetDataContainer c = (PresetDataContainer)levelData;
            return c.getPreset();
        }
        return null;
    }

    public static void setServerPreset(MinecraftServer server, Preset set) {
        if (server == null) {
            return;
        }
        for (ServerLevel l : server.getAllLevels()) {
            LevelData levelData = l.getLevelData();
            if (!(levelData instanceof PresetDataContainer)) continue;
            PresetDataContainer c = (PresetDataContainer)levelData;
            c.setPreset(set);
        }
    }

    public static void handleSetPresetPacket(SelectPresetC2SPayload selectPresetPayload, MinecraftServer server, ServerPlayer player) {
        if (player.getPermissionLevel() < 3) {
            return;
        }
        Preset preset = selectPresetPayload.preset();
        if (!preset.enabled) {
            return;
        }
        Preset old = PresetManager.setMapPreset(preset, server);
        if (server == null) {
            return;
        }
        PresetManager.loadAndReplacePresetPack(server, preset, old);
        for (ServerLevel l : server.getAllLevels()) {
            LevelData levelData = l.getLevelData();
            if (!(levelData instanceof PresetDataContainer)) continue;
            PresetDataContainer c = (PresetDataContainer)levelData;
            c.setPreset(preset);
        }
    }

    private static Preset setMapPreset(Preset preset, MinecraftServer server) {
        Preset oldPreset = PresetManager.getServerPreset(server);
        if (oldPreset == null) {
            oldPreset = selectedPreset;
        }
        PresetManager.setServerPreset(server, preset);
        selectedPreset = preset;
        return oldPreset;
    }

    public static void checkAndEnsurePresetPackLoaded(ServerLevel serverLevel) {
        Preset preset;
        MinecraftServer loadedServer = serverLevel.getServer();
        LevelData levelData = serverLevel.getLevelData();
        if (levelData instanceof PresetDataContainer) {
            PresetDataContainer c = (PresetDataContainer)levelData;
            preset = c.getPreset();
        } else {
            Preset sp = PresetManager.getServerPreset(loadedServer);
            preset = sp != null ? sp : selectedPreset;
        }
        if (preset == null || preset == DEFAULT) {
            return;
        }
        PackRepository repo = loadedServer.getPackRepository();
        if (repo.getAvailableIds().stream().anyMatch(id -> id.contains(preset.presetName))) {
            return;
        }
        PresetManager.loadAndReplacePresetPack(loadedServer, preset, null);
    }

    private static void loadAndReplacePresetPack(MinecraftServer server, @NotNull Preset newPreset, @Nullable Preset oldPreset) {
        Path packDir = server.getWorldPath(LevelResource.DATAPACK_DIR);
        Path oldPack = oldPreset != null ? packDir.resolve(oldPreset.presetName + ".zip") : null;
        Path newPack = packDir.resolve(newPreset.presetName + ".zip");
        Logger logger = LogUtils.getLogger();
        logger.info("Selecting preset {} at {}", (Object)newPreset.presetName, (Object)newPack);
        if (oldPreset != null) {
            server.reloadResources(server.getPackRepository().getSelectedIds().stream().filter(s -> !s.contains(oldPreset.presetName)).toList()).join();
            logger.info("Removing preset {} at {}", (Object)oldPreset.presetName, (Object)oldPack);
            try {
                Files.deleteIfExists(oldPack);
            }
            catch (IOException ignored) {
                logger.error("oh, that removal failed.....");
            }
        }
        if (newPreset == DEFAULT) {
            server.getPackRepository().reload();
            return;
        }
        Resource newPackResource = packDefaults.get((Object)newPreset);
        try {
            InputStream packResources = newPackResource.open();
            Files.copy(packResources, newPack, StandardCopyOption.REPLACE_EXISTING);
            packResources.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        logger.info("Successfully loaded preset datapack!");
        server.getPackRepository().reload();
        Pack pack = PresetManager.getPack(server, "file/" + newPreset.presetName + ".zip");
        PresetManager.enablePack(server, pack);
    }

    private static Pack getPack(MinecraftServer server, String packName) {
        PackRepository packRepository = server.getPackRepository();
        Pack pack = packRepository.getPack(packName);
        if (pack == null) {
            LogUtils.getLogger().error("Preset {} pack not found!", (Object)packName);
        } else {
            boolean bl2 = packRepository.getSelectedPacks().contains(pack);
            if (bl2) {
                LogUtils.getLogger().error("Preset {} pack alread enabled!", (Object)packName);
            } else {
                return pack;
            }
        }
        return null;
    }

    private static void enablePack(MinecraftServer server, Pack pack) {
        PackRepository packRepository = server.getPackRepository();
        ArrayList list = Lists.newArrayList((Iterable)packRepository.getSelectedPacks());
        Pack.Position.BOTTOM.insert((List)list, (Object)pack, Pack::selectionConfig, false);
        server.reloadResources((Collection)list.stream().map(Pack::getId).collect(Collectors.toList()));
    }

    private static Preset setMapPreset(Preset preset) {
        Preset oldPreset = selectedPreset;
        selectedPreset = preset;
        return oldPreset;
    }

    public static enum Preset implements StringRepresentable
    {
        VANILLA("vanilla", ImprovedMapColors.resource("preset/vanilla")),
        VANILLA_FIXED("vanilla_fixed", ImprovedMapColors.resource("preset/vanilla_fixed"), false),
        GNEISS_PREFERED("gneiss", ImprovedMapColors.resource("preset/gneiss"), false),
        SEPIA("sepia", ImprovedMapColors.resource("preset/sepia")),
        GRAYSCALE("grayscale", ImprovedMapColors.resource("preset/grayscale")),
        PIP_BOY("gameboy", ImprovedMapColors.resource("preset/gameboy")),
        INVERTED("inverted", ImprovedMapColors.resource("preset/inverted")),
        REDISTRIBUTED_COLORS("redistributed", ImprovedMapColors.resource("preset/redistributed"), false);

        public final String presetName;
        public final ResourceLocation presetLocation;
        public final boolean enabled;

        private Preset(String presetName, ResourceLocation presetLocation) {
            this(presetName, presetLocation, true);
        }

        private Preset(String presetName, ResourceLocation presetLocation, boolean enabled) {
            this.presetName = presetName;
            this.presetLocation = presetLocation;
            this.enabled = enabled;
        }

        @NotNull
        public String getSerializedName() {
            return this.presetName;
        }

        public static Preset getFromSeiralizedName(String name) {
            for (Preset p : Preset.values()) {
                if (!p.presetName.equals(name)) continue;
                return p;
            }
            return VANILLA;
        }
    }
}

