/*
 * Decompiled with CFR 0.152.
 */
package org.gneisscode.improvedmapcolors.client;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.OptionsSubScreen;
import net.minecraft.network.chat.Component;
import org.gneisscode.improvedmapcolors.PresetManager;

public class PresetOptionsScreen
extends OptionsSubScreen {
    private Map<PresetManager.Preset, Button> buttons = new Object2ObjectArrayMap();

    public PresetOptionsScreen(Screen screen, Options options, Component component) {
        super(screen, options, component);
    }

    protected void addOptions() {
        if (this.list != null) {
            for (PresetManager.Preset p : PresetManager.Preset.values()) {
                if (!p.enabled) continue;
                Button b = Button.builder((Component)Component.translatable((String)("improvedmapcolors.configuration.preset.button." + p.getSerializedName())), s -> {
                    PresetManager.setAndSendSelectedPreset(p);
                    this.refreshButtons();
                }).build();
                this.buttons.put(p, b);
                StringWidget label = new StringWidget(150, 20, (Component)Component.translatable((String)("improvedmapcolors.configuration.preset." + p.getSerializedName())), this.font).alignLeft();
                label.setTooltip(Tooltip.create((Component)Component.translatable((String)"improvedmapcolors.configuration.preset.%s.tooltip".formatted(p.getSerializedName()))));
                this.list.addSmall((AbstractWidget)label, (AbstractWidget)b);
            }
            this.refreshButtons();
        }
    }

    public void refreshButtons() {
        for (PresetManager.Preset p : this.buttons.keySet()) {
            this.buttons.get((Object)((Object)p)).active = PresetManager.selectedPreset != p;
        }
    }
}

