/*
 * Decompiled with CFR 0.152.
 */
package org.gneisscode.improvedmapcolors.neoforge.networking;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.gneisscode.improvedmapcolors.ColorListManager;
import org.gneisscode.improvedmapcolors.PresetManager;
import org.gneisscode.improvedmapcolors.client.ImprovedMapColorsClient;
import org.gneisscode.improvedmapcolors.networking.ColorListSyncPayload;
import org.gneisscode.improvedmapcolors.networking.PresetSyncS2CPacket;
import org.gneisscode.improvedmapcolors.networking.SelectPresetC2SPayload;

@EventBusSubscriber(modid="improvedmapcolors")
public class RegisterPackets {
    @SubscribeEvent
    public static void registerPacketPayloads(RegisterPayloadHandlersEvent evt) {
        PayloadRegistrar registrar = evt.registrar("1");
        registrar.commonToClient(ColorListSyncPayload.ID, ColorListSyncPayload.NEO_CODEC, (payload, ctx) -> {
            ImprovedMapColorsClient.refreshMapImages();
            ColorListManager.handleSyncPayload(payload);
        });
        registrar.commonToServer(SelectPresetC2SPayload.ID, SelectPresetC2SPayload.NEO_PAYLOAD_CODEC, (payload, ctx) -> {
            Player patt0$temp = ctx.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                PresetManager.handleSetPresetPacket(payload, player.getServer(), player);
            }
        });
        registrar.commonToClient(PresetSyncS2CPacket.ID, PresetSyncS2CPacket.NEO_PAYLOAD_CODEC, (payload, ctx) -> {
            ImprovedMapColorsClient.refreshMapImages();
            PresetManager.selectedPreset = payload.chosenPreset();
        });
    }
}

