/*
 * Decompiled with CFR 0.152.
 */
package org.gneisscode.improvedmapcolors.presets;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.minecraft.world.level.block.state.BlockState;
import org.gneisscode.improvedmapcolors.ColorListManager;
import org.gneisscode.improvedmapcolors.ColorStateMapManager;
import org.gneisscode.improvedmapcolors.resourcestuff.ColorListHolder;
import org.gneisscode.improvedmapcolors.resourcestuff.StateMapHolder;
import org.jetbrains.annotations.Nullable;

public class PresetDatapackExportTool {
    public static final Gson json = new GsonBuilder().setPrettyPrinting().create();

    public static void exportDataPackPresetFromCSV(File outFile, @Nullable String packName) throws IOException {
        try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(outFile));){
            Map<BlockState, ColorStateMapManager.BlockStatePropertyTracker> stateColorMap;
            List<Color> csvColorList = ColorListManager.overridingColorList();
            if (csvColorList != null) {
                csvColorList = csvColorList.stream().toList();
                ColorListHolder holder = new ColorListHolder(csvColorList);
                DataResult colorListResult = ColorListHolder.COLOR_LIST_CODEC.encode((Object)holder, (DynamicOps)JsonOps.INSTANCE, (Object)new JsonObject());
                JsonElement colorList = (JsonElement)colorListResult.getOrThrow();
                ZipEntry colors = new ZipEntry("data/" + packName + "/mapcolors/colors/preset_color_list.json");
                out.putNextEntry(colors);
                String outText = json.toJson(colorList);
                byte[] data = outText.getBytes(StandardCharsets.UTF_8);
                out.write(data, 0, data.length);
                out.closeEntry();
            }
            if ((stateColorMap = ColorStateMapManager.getOverridingStateTrackerMap()) != null) {
                StateMapHolder holder = new StateMapHolder(stateColorMap.values().stream().toList());
                DataResult stateListResult = StateMapHolder.STATE_HOLDER_CODEC.encode((Object)holder, (DynamicOps)JsonOps.INSTANCE, (Object)new JsonObject());
                JsonElement stateList = (JsonElement)stateListResult.getOrThrow();
                ZipEntry states = new ZipEntry("data/" + packName + "/mapcolors/states/preset_state_list.json");
                out.putNextEntry(states);
                String outText = json.toJson(stateList);
                byte[] data = outText.getBytes(StandardCharsets.UTF_8);
                out.write(data, 0, data.length);
                out.closeEntry();
            }
            ZipEntry pack_mcmeta = new ZipEntry("pack.mcmeta");
            out.putNextEntry(pack_mcmeta);
            JsonObject root = new JsonObject();
            JsonObject pack = new JsonObject();
            pack.addProperty("pack_format", (Number)81);
            JsonObject description = new JsonObject();
            description.addProperty("text", packName + " preset for map colors");
            pack.add("description", (JsonElement)description);
            root.add("pack", (JsonElement)pack);
            String packMcmetaString = json.toJson((JsonElement)root);
            byte[] packMcmetaData = packMcmetaString.getBytes(StandardCharsets.UTF_8);
            out.write(packMcmetaData, 0, packMcmetaData.length);
            out.closeEntry();
            out.close();
        }
    }
}

