/*
 * Decompiled with CFR 0.152.
 */
package org.gneisscode.improvedmapcolors.resourcestuff;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.awt.Color;
import java.util.List;
import java.util.Map;

public class ColorListHolder {
    public static Codec<ColorListHolder> COLOR_LIST_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).fieldOf("colorList").forGetter(f -> {
        Object2ObjectArrayMap colorMap = new Object2ObjectArrayMap();
        for (int i = 0; i < f.colorList.size(); ++i) {
            Color color = f.colorList.get(i);
            if (color == null) continue;
            colorMap.put(Integer.toString(i), String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue()));
        }
        return colorMap;
    })).apply((Applicative)instance, ColorListHolder::new));
    public List<Color> colorList;

    public ColorListHolder(Map<String, String> colorIndexMap) {
        this.colorList = Lists.newArrayListWithCapacity((int)64);
        for (int i = 0; i < 64; ++i) {
            String s = colorIndexMap.get(Integer.toString(i));
            if (s == null) {
                this.colorList.add(i, null);
                continue;
            }
            try {
                this.colorList.add(i, Color.decode(s));
                continue;
            }
            catch (NumberFormatException e) {
                LogUtils.getLogger().error("Color unable to be read!");
            }
        }
    }

    public ColorListHolder(List<Color> colorList) {
        this.colorList = colorList;
    }

    public void addColorsToList(List<Color> inputList) {
        for (int i = 0; i < inputList.size(); ++i) {
            Color ourColor = this.colorList.get(i);
            if (ourColor == null) continue;
            inputList.set(i, ourColor);
        }
    }
}

