/*
 * Decompiled with CFR 0.152.
 */
package org.gneisscode.improvedmapcolors.resourcestuff;

import com.mojang.logging.LogUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.material.MapColor;
import org.gneisscode.improvedmapcolors.ColorListManager;
import org.gneisscode.improvedmapcolors.CommonConfig;
import org.gneisscode.improvedmapcolors.resourcestuff.ColorListHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorListResourceReloadListener
extends SimpleJsonResourceReloadListener<ColorListHolder> {
    public static final FileToIdConverter ASSET_LISTER = FileToIdConverter.json((String)"mapcolors/colors");
    public static final ColorListResourceReloadListener LISTENER = new ColorListResourceReloadListener();

    protected ColorListResourceReloadListener() {
        super(ColorListHolder.COLOR_LIST_CODEC, ASSET_LISTER);
    }

    protected void apply(Map<ResourceLocation, ColorListHolder> holderMap, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        if (!((CommonConfig.ConfigMode)((Object)CommonConfig.CONFIG.colorConfigMode.get())).hasDatapack()) {
            return;
        }
        @NotNull ArrayList<@Nullable Color> colorList = new ArrayList<Color>(MapColor.MATERIAL_COLORS.length);
        for (int i = 0; i < MapColor.MATERIAL_COLORS.length; ++i) {
            colorList.add(null);
        }
        profilerFiller.push("Map Color List Colors Reload");
        holderMap.forEach((rl, holder) -> holder.addColorsToList(colorList));
        profilerFiller.pop();
        LogUtils.getLogger().info("Reloaded map colors!");
        ColorListManager.setDatapackColorList(colorList);
    }
}

