/*
 * Decompiled with CFR 0.152.
 */
package org.gneisscode.improvedmapcolors.resourcestuff;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.gneisscode.improvedmapcolors.ColorStateMapManager;
import org.jetbrains.annotations.NotNull;

public class StateMapHolder {
    public static final Codec<StateMapHolder> STATE_HOLDER_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list(ColorStateMapManager.BlockStatePropertyTracker.PROPERTY_TRACKER_CODEC).fieldOf("stateColorIDList").forGetter(f -> f.stateColorIDMap)).apply((Applicative)instance, StateMapHolder::new));
    public List<ColorStateMapManager.BlockStatePropertyTracker> stateColorIDMap;

    public StateMapHolder(List<ColorStateMapManager.BlockStatePropertyTracker> stateColorMap) {
        this.stateColorIDMap = stateColorMap;
    }

    public void addTrackersToMap(@NotNull Map<BlockState, ColorStateMapManager.BlockStatePropertyTracker> trackerMap) {
        for (ColorStateMapManager.BlockStatePropertyTracker t : this.stateColorIDMap) {
            trackerMap.put(t.state(), t);
        }
    }

    public void addStatesToMap(Map<BlockState, Integer> stateColorIDMap) {
        for (ColorStateMapManager.BlockStatePropertyTracker tracker : this.stateColorIDMap) {
            BlockState defaultState = tracker.state().getBlock().defaultBlockState();
            for (Property p : tracker.state().getProperties()) {
                if (p instanceof IntegerProperty) {
                    IntegerProperty ip = (IntegerProperty)p;
                    defaultState = StateMapHolder.setProperty(defaultState, ip, ip.getName((Integer)tracker.state().getValue((Property)ip)));
                    continue;
                }
                if (p instanceof BooleanProperty) {
                    BooleanProperty bp = (BooleanProperty)p;
                    defaultState = StateMapHolder.setProperty(defaultState, bp, bp.getName((Boolean)tracker.state().getValue((Property)bp)));
                    continue;
                }
                if (!(p instanceof EnumProperty)) continue;
                EnumProperty ep = (EnumProperty)p;
                defaultState = StateMapHolder.setProperty(defaultState, ep, ((StringRepresentable)((Enum)((Object)tracker.state().getValue((Property)ep)))).getSerializedName());
            }
            stateColorIDMap.put(tracker.state(), tracker.colorID());
        }
    }

    public static <T extends Comparable<T>> BlockState setProperty(BlockState state, Property<T> property, String value) {
        Optional val = property.getValue(value);
        return val.map(t -> (BlockState)state.setValue(property, t)).orElse(state);
    }

    public void addTrackedPropertiesToMap(Map<BlockState, List<String>> statePropertyListMap) {
        for (ColorStateMapManager.BlockStatePropertyTracker tracker : this.stateColorIDMap) {
            if (tracker.trackedProperties() == null) continue;
            statePropertyListMap.put(tracker.state(), tracker.trackedProperties());
        }
    }
}

