/*
 * Decompiled with CFR 0.152.
 */
package com.dplayend.spawnercontrol.handler;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class HandlerConfig {
    public static Common COMMON = new Common();

    public static void init(File configFolder) {
        HandlerConfig.commonFile(configFolder);
    }

    private static void commonFile(File configFolder) {
        File configFile = new File(configFolder, "spawner_control-common.json");
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        if (configFile.exists()) {
            try {
                FileReader fileReader = new FileReader(configFile);
                COMMON = (Common)gson.fromJson((Reader)fileReader, Common.class);
                fileReader.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        COMMON = new Common();
        try {
            FileWriter fileWriter = new FileWriter(configFile);
            fileWriter.write(gson.toJson((Object)COMMON));
            fileWriter.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Common {
        public static boolean dv_ignoreRestrictions = false;
        public static boolean dv_spawnLimit = true;
        public static int dv_spawnLimitValue = 15;
        public static boolean dv_dropXp = true;
        public static int dv_dropXpValueBase = 15;
        public static int dv_dropXpValueAdd1 = 15;
        public static int dv_dropXpValueAdd2 = 15;
        public static int dv_spawnCount = 4;
        public static int dv_spawnRange = 4;
        public static int dv_spawnDelay = 20;
        public static int dv_minSpawnDelay = 200;
        public static int dv_maxSpawnDelay = 800;
        public static int dv_playerRange = 16;
        public static int dv_maxNearbyEntities = 6;
        public static String dv_lootDropType = "ROLL";
        public static float dv_lootDropChance = 1.0f;
        public boolean ignoreRestrictions = dv_ignoreRestrictions;
        public boolean spawnLimit = dv_spawnLimit;
        public int spawnLimitValue = dv_spawnLimitValue;
        public boolean dropXp = dv_dropXp;
        public int dropXpValueBase = dv_dropXpValueBase;
        public int dropXpValueAdd1 = dv_dropXpValueAdd1;
        public int dropXpValueAdd2 = dv_dropXpValueAdd2;
        public int spawnCount = dv_spawnCount;
        public int spawnRange = dv_spawnRange;
        public int spawnDelay = dv_spawnDelay;
        public int minSpawnDelay = dv_minSpawnDelay;
        public int maxSpawnDelay = dv_maxSpawnDelay;
        public int playerRange = dv_playerRange;
        public int maxNearbyEntities = dv_maxNearbyEntities;
        public String lootDropType = dv_lootDropType;
        public float lootDropChance = dv_lootDropChance;
        public List<String> lootDropList = Common.dv_lootDropList();

        public static List<String> dv_lootDropList() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("minecraft:gold_ingot=2");
            list.add("minecraft:glowstone_dust=4");
            list.add("minecraft:lapis_lazuli=4");
            list.add("minecraft:diamond=1");
            list.add("minecraft:redstone=4");
            return list;
        }
    }
}

