/*
 * Decompiled with CFR 0.152.
 */
package com.dplayend.spawnercontrol.mixin;

import com.dplayend.spawnercontrol.handler.HandlerConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.SpawnData;
import net.minecraftforge.event.ForgeEventFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BaseSpawner.class})
public abstract class MixSpawner {
    @Unique
    private boolean canCount = false;
    @Unique
    private int spawnLimit = 0;
    @Shadow
    private int spawnDelay;
    @Shadow
    private int minSpawnDelay;
    @Shadow
    private int maxSpawnDelay;
    @Shadow
    private int spawnCount;
    @Shadow
    private int maxNearbyEntities;
    @Shadow
    private int requiredPlayerRange;
    @Shadow
    private int spawnRange;

    public MixSpawner() {
        this.spawnDelay = HandlerConfig.COMMON.spawnDelay;
        this.minSpawnDelay = HandlerConfig.COMMON.minSpawnDelay;
        this.maxSpawnDelay = HandlerConfig.COMMON.maxSpawnDelay;
        this.spawnCount = HandlerConfig.COMMON.spawnCount;
        this.maxNearbyEntities = HandlerConfig.COMMON.maxNearbyEntities;
        this.requiredPlayerRange = HandlerConfig.COMMON.playerRange;
        this.spawnRange = HandlerConfig.COMMON.spawnRange;
    }

    @Inject(method={"serverTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;levelEvent(ILnet/minecraft/core/BlockPos;I)V")})
    public void updateCount(CallbackInfo info) {
        if (HandlerConfig.COMMON.spawnLimit) {
            this.canCount = true;
        }
    }

    @Inject(method={"serverTick"}, at={@At(value="HEAD")})
    public void serverTick(ServerLevel serverLevel, BlockPos blockPos, CallbackInfo info) {
        if (this.spawnDelay >= this.maxSpawnDelay) {
            this.spawnDelay = this.maxSpawnDelay;
        }
        this.minSpawnDelay = HandlerConfig.COMMON.minSpawnDelay;
        this.maxSpawnDelay = HandlerConfig.COMMON.maxSpawnDelay;
        this.spawnCount = HandlerConfig.COMMON.spawnCount;
        this.maxNearbyEntities = HandlerConfig.COMMON.maxNearbyEntities;
        this.requiredPlayerRange = HandlerConfig.COMMON.playerRange;
        this.spawnRange = HandlerConfig.COMMON.spawnRange;
        if (this.canCount) {
            ++this.spawnLimit;
            this.canCount = false;
        }
        if (this.spawnLimit >= HandlerConfig.COMMON.spawnLimitValue) {
            serverLevel.destroyBlock(blockPos, HandlerConfig.COMMON.dropXp);
        }
    }

    @Redirect(method={"serverTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/SpawnPlacements;checkSpawnRules(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/ServerLevelAccessor;Lnet/minecraft/world/entity/EntitySpawnReason;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)Z"))
    public boolean canSpawn(EntityType<Entity> type, ServerLevelAccessor world, EntitySpawnReason spawnReason, BlockPos pos, RandomSource random) {
        if (HandlerConfig.COMMON.ignoreRestrictions) {
            return true;
        }
        return SpawnPlacements.checkSpawnRules(type, (ServerLevelAccessor)world, (EntitySpawnReason)spawnReason, (BlockPos)pos, (RandomSource)random);
    }

    @Redirect(method={"serverTick"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/event/ForgeEventFactory;checkSpawnPositionSpawner(Lnet/minecraft/world/entity/Mob;Lnet/minecraft/world/level/ServerLevelAccessor;Lnet/minecraft/world/entity/EntitySpawnReason;Lnet/minecraft/world/level/SpawnData;Lnet/minecraft/world/level/BaseSpawner;)Z"))
    public boolean canSpawn(Mob instance, ServerLevelAccessor level, EntitySpawnReason spawnType, SpawnData spawnData, BaseSpawner spawner) {
        if (HandlerConfig.COMMON.ignoreRestrictions) {
            if (instance instanceof Monster) {
                return level.getDifficulty() != Difficulty.PEACEFUL;
            }
            return true;
        }
        return ForgeEventFactory.checkSpawnPositionSpawner((Mob)instance, (ServerLevelAccessor)level, (EntitySpawnReason)spawnType, (SpawnData)spawnData, (BaseSpawner)spawner);
    }

    @Inject(method={"load"}, at={@At(value="TAIL")})
    public void readNbt(Level world, BlockPos pos, CompoundTag nbt, CallbackInfo ci) {
        if (HandlerConfig.COMMON.spawnLimit) {
            this.spawnLimit = nbt.getIntOr("Limit", 0);
        }
        this.spawnDelay = nbt.getShortOr("Delay", (short)HandlerConfig.COMMON.spawnDelay);
        this.minSpawnDelay = nbt.getIntOr("MinSpawnDelay", HandlerConfig.COMMON.minSpawnDelay);
        this.maxSpawnDelay = nbt.getIntOr("MaxSpawnDelay", HandlerConfig.COMMON.maxSpawnDelay);
        this.spawnCount = nbt.getIntOr("SpawnCount", HandlerConfig.COMMON.spawnCount);
        this.maxNearbyEntities = nbt.getIntOr("MaxNearbyEntities", HandlerConfig.COMMON.maxNearbyEntities);
        this.requiredPlayerRange = nbt.getIntOr("RequiredPlayerRange", HandlerConfig.COMMON.playerRange);
        this.spawnRange = nbt.getIntOr("SpawnRange", HandlerConfig.COMMON.spawnRange);
    }

    @Inject(method={"save"}, at={@At(value="TAIL")})
    public void writeNbt(CompoundTag nbt, CallbackInfoReturnable<CompoundTag> info) {
        if (HandlerConfig.COMMON.spawnLimit) {
            nbt.putInt("Limit", (int)((short)this.spawnLimit));
        }
        nbt.putShort("Delay", (short)this.spawnDelay);
        nbt.putShort("MinSpawnDelay", (short)this.minSpawnDelay);
        nbt.putShort("MaxSpawnDelay", (short)this.maxSpawnDelay);
        nbt.putShort("SpawnCount", (short)this.spawnCount);
        nbt.putShort("MaxNearbyEntities", (short)this.maxNearbyEntities);
        nbt.putShort("RequiredPlayerRange", (short)this.requiredPlayerRange);
        nbt.putShort("SpawnRange", (short)this.spawnRange);
    }
}

