/*
 * Decompiled with CFR 0.152.
 */
package com.dplayend.spawnercontrol.mixin;

import com.dplayend.spawnercontrol.handler.HandlerConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SpawnerBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SpawnerBlock.class})
public abstract class MixSpawnerBlock {
    @Inject(method={"spawnAfterBreak"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/BaseEntityBlock;spawnAfterBreak(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/item/ItemStack;Z)V")}, cancellable=true)
    public void spawnAfterBreak(BlockState state, ServerLevel world, BlockPos pos, ItemStack tool, boolean dropExperience, CallbackInfo info) {
        info.cancel();
        if (!tool.isEmpty() && !this.getItemsFromConfig().isEmpty() && (int)Math.floor(Math.random() * (double)(1.0f / HandlerConfig.COMMON.lootDropChance)) == 0) {
            if (HandlerConfig.COMMON.lootDropType.equals("ALL")) {
                for (ItemStack stack : this.getItemsFromConfig()) {
                    world.addFreshEntity((Entity)new ItemEntity((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), stack));
                }
            }
            if (HandlerConfig.COMMON.lootDropType.equals("ROLL")) {
                int chooseItem = (int)Math.floor(Math.random() * (double)this.getItemsFromConfig().size());
                world.addFreshEntity((Entity)new ItemEntity((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), this.getItemsFromConfig().get(chooseItem)));
            }
        }
    }

    @Inject(method={"getExpDrop"}, at={@At(value="TAIL")}, cancellable=true, remap=false)
    public void dropExperience(BlockState state, LevelReader level, RandomSource randomSource, BlockPos pos, int fortuneLevel, int silkTouchLevel, CallbackInfoReturnable<Integer> info) {
        int i = HandlerConfig.COMMON.dropXpValueBase + randomSource.nextInt(HandlerConfig.COMMON.dropXpValueAdd1) + randomSource.nextInt(HandlerConfig.COMMON.dropXpValueAdd2);
        info.setReturnValue((Object)(HandlerConfig.COMMON.dropXp ? i : 0));
    }

    private List<ItemStack> getItemsFromConfig() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (String stack : HandlerConfig.COMMON.lootDropList) {
            String item = stack.split("=")[0];
            int amount = Integer.parseInt(stack.split("=")[1]);
            int randomAmount = (int)Math.floor(Math.random() * (double)amount) + 1;
            list.add(new ItemStack((ItemLike)BuiltInRegistries.ITEM.getValue(ResourceLocation.parse((String)item)), randomAmount));
        }
        return list;
    }
}

