/*
 * Decompiled with CFR 0.152.
 */
package me.drawn;

import java.io.File;
import java.util.logging.Logger;
import me.drawn.commands.MainCommand;
import me.drawn.commands.MainCommandTabComplete;
import me.drawn.gui.VerseGUI;
import me.drawn.integrations.IntegrationsManager;
import me.drawn.management.BuiltinGenerators;
import me.drawn.management.VerseGeneratorManager;
import me.drawn.management.VerseWorldManager;
import me.drawn.management.entities.VerseGenerator;
import me.drawn.management.flags.FlagEvents;
import me.drawn.management.flags.FlagManager;
import me.drawn.management.flags.FlagRunnable;
import me.drawn.utils.ServerVersion;
import me.drawn.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class MegaVerse
extends JavaPlugin {
    public static File worldConfigsFolder;
    public static boolean pluginUpdated;
    public static Logger l;

    public static MegaVerse getInstance() {
        return (MegaVerse)MegaVerse.getPlugin(MegaVerse.class);
    }

    public void onEnable() {
        l = this.getLogger();
        worldConfigsFolder.mkdirs();
        ServerVersion.determineVersion();
        MegaVerse.log(Utils.GREEN_COLOR + " _  _  ____  ___   __   _  _  ____  ____  ____  ____ ");
        MegaVerse.log(Utils.GREEN_COLOR + "( \\/ )(  __)/ __) / _\\ / )( \\(  __)(  _ \\/ ___)(  __)");
        MegaVerse.log(Utils.GREEN_COLOR + "/ \\/ \\ ) _)( (_ \\/    \\\\ \\/ / ) _)  )   /\\___ \\ ) _)");
        MegaVerse.log(Utils.GREEN_COLOR + "\\_)(_/(____)\\___/\\_/\\_/ \\__/ (____)(__\\_)(____/(____)");
        MegaVerse.empty();
        MegaVerse.log(Utils.GREEN_COLOR + "&lEnabling MegaVerse v" + this.getDescription().getVersion());
        MegaVerse.log(Utils.GREEN_COLOR + "&lRunning on " + ServerVersion.serverVersion + " - MC " + ServerVersion.mcVersion);
        MegaVerse.empty();
        MegaVerse.log(Utils.GREEN_COLOR + "&o< Do you like MegaVerse? There's no premium version, so consider donating! https://patreon.com/drawned or https://ko-fi.com/drawned >&r");
        MegaVerse.empty();
        MegaVerse.log("&fImporting default world generators from other plugins, you can ignore any errors below.");
        VerseGeneratorManager.importGenericGenerators();
        MegaVerse.empty();
        MegaVerse.log("&fInitializing commands...");
        this.getCommand("megaverse").setExecutor((CommandExecutor)new MainCommand());
        if (ServerVersion.newerThan1_13) {
            this.getCommand("megaverse").setTabCompleter((TabCompleter)new MainCommandTabComplete());
        }
        MegaVerse.empty();
        MegaVerse.log("&fInitializing events...");
        this.getServer().getPluginManager().registerEvents((Listener)new VerseGUI(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new FlagEvents(), (Plugin)this);
        MegaVerse.empty();
        MegaVerse.log("&fLoading worlds...");
        VerseWorldManager.loadExistingWorlds();
        MegaVerse.empty();
        MegaVerse.log("&fInitializing integrations and hooks...");
        IntegrationsManager.initialize();
        MegaVerse.empty();
        MegaVerse.log("&fChecking for updates...");
        Utils.checkUpdates(version -> {
            if (this.getDescription().getVersion().equals(version)) {
                MegaVerse.secondLog("The plugin is updated!");
            } else {
                pluginUpdated = false;
                MegaVerse.secondLogError("There is a new update available. MegaVerse is constantly under development and new features are added all the time. You can downloaded the most recent version here: https://www.spigotmc.org/resources/124726/ or https://modrinth.com/plugin/megaverse");
            }
        });
        MegaVerse.empty();
        MegaVerse.log("&fStarting plugin Runnables...");
        new FlagRunnable().runTaskTimer((Plugin)this, 60L, 40L);
        FlagManager.all();
    }

    public void onLoad() {
        this.getDataFolder().mkdirs();
        worldConfigsFolder = new File(this.getDataFolder(), "world_configs");
        BuiltinGenerators.registerAll();
    }

    public void onDisable() {
    }

    public ChunkGenerator getDefaultWorldGenerator(@NotNull String worldName, String id) {
        VerseGenerator verseGenerator = VerseGeneratorManager.getVerseGeneratorById(id);
        if (verseGenerator != null) {
            return verseGenerator.getChunkGenerator();
        }
        return null;
    }

    public static void empty() {
        l.info(" ");
    }

    public static void log(String message) {
        Bukkit.getConsoleSender().sendMessage("[MegaVerse] " + Utils.c(message));
    }

    public static void firstLog(String message) {
        MegaVerse.log(Utils.GREEN_COLOR + "| " + message);
    }

    public static void secondLog(String message) {
        MegaVerse.log("  " + Utils.DARK_GREEN_COLOR + "| " + message);
    }

    public static void secondLogError(String message) {
        MegaVerse.log("  " + Utils.WARNING_COLOR + "| " + message);
    }

    static {
        pluginUpdated = true;
    }
}

