/*
 * Decompiled with CFR 0.152.
 */
package me.drawn.commands;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import me.drawn.commands.MainCommand;
import me.drawn.management.VerseImportManager;
import me.drawn.management.VerseWorldManager;
import me.drawn.management.flags.Flag;
import me.drawn.management.flags.FlagManager;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class MainCommandTabComplete
implements TabCompleter {
    @Nullable
    public List<String> onTabComplete(CommandSender s, Command cmd, String label, String[] args) {
        if (s instanceof Player) {
            Player p = (Player)s;
            p.playSound(p.getLocation(), Sound.ENTITY_CHICKEN_EGG, 0.5f, 1.0f);
        }
        if (args.length == 1) {
            return MainCommand.SUB_COMMANDS;
        }
        String subCommand = args[0].toLowerCase();
        if (!s.hasPermission("megaverse.command." + subCommand)) {
            return List.of();
        }
        if (args.length == 2) {
            if (subCommand.equals("create")) {
                return List.of("<world_name>");
            }
            if (subCommand.equals("info") || subCommand.equals("who") || subCommand.equals("unload") || subCommand.equals("tp")) {
                return VerseWorldManager.getLoadedWorldsNames();
            }
            if (subCommand.equals("delete")) {
                return VerseWorldManager.unloadedWorlds;
            }
            if (subCommand.equals("import")) {
                return VerseImportManager.getValidImportableWorlds();
            }
        }
        if (subCommand.equals("flag")) {
            Flag<?> flag;
            if (args.length == 2) {
                return MainCommand.FLAG_SUB_COMMANDS;
            }
            if (args.length == 3) {
                return VerseWorldManager.getLoadedWorldsNames();
            }
            if (args.length == 4) {
                return FlagManager.allFlagIds();
            }
            if (args.length == 5 && (flag = FlagManager.get(args[3])) != null) {
                FlagManager.ValueType valueType = flag.getValueType();
                if (valueType == FlagManager.ValueType.STRING) {
                    return List.of("<message>");
                }
                if (valueType == FlagManager.ValueType.BOOLEAN) {
                    return Arrays.asList("true", "false");
                }
                if (valueType == FlagManager.ValueType.INTEGER) {
                    return List.of("<number>");
                }
            }
        }
        return List.of();
    }
}

