/*
 * Decompiled with CFR 0.152.
 */
package me.drawn.gui;

import me.drawn.gui.VerseGUI;
import me.drawn.gui.custom.WorldCreationGUI;
import me.drawn.gui.custom.WorldImportGUI;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class EnvironmentGUI {
    public static final Inventory inventory = EnvironmentGUI.generateInventory();

    private static Inventory generateInventory() {
        Inventory inventory = Bukkit.createInventory(null, (int)27, (String)"Select the world environment");
        inventory.setItem(10, VerseGUI.simpleButton(Material.NETHERRACK, "Nether", "Click to select the world type", "as a Nether type."));
        inventory.setItem(13, VerseGUI.simpleButton(Material.GRASS_BLOCK, "Overworld", "Click to select the world type", "as the normal Overworld type."));
        inventory.setItem(16, VerseGUI.simpleButton(Material.END_STONE, "The End", "Click to select the world type", "as The End type."));
        return inventory;
    }

    public static void onClick(int slot, Player player, Inventory inv, VerseGUI.Type type) {
        World.Environment environment = EnvironmentGUI.getWorldEnvironmentInSlot(slot);
        if (type == VerseGUI.Type.CREATION_GUI) {
            WorldCreationGUI.selectEnvironment(player, environment);
        } else {
            WorldImportGUI.selectEnvironment(player, environment);
        }
    }

    public static World.Environment getWorldEnvironmentInSlot(int slot) {
        switch (slot) {
            case 10: {
                return World.Environment.NETHER;
            }
            case 13: {
                return World.Environment.NORMAL;
            }
            case 16: {
                return World.Environment.THE_END;
            }
        }
        return World.Environment.NORMAL;
    }
}

