/*
 * Decompiled with CFR 0.152.
 */
package me.drawn.gui;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import me.drawn.gui.VerseGUI;
import me.drawn.gui.custom.WorldCreationGUI;
import me.drawn.management.VerseGeneratorManager;
import me.drawn.management.entities.CustomGenerator;
import me.drawn.management.entities.VerseGenerator;
import me.drawn.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GeneratorsGUI {
    private static final HashMap<Integer, CustomGenerator> generatorHashMap = new HashMap();
    public static final Inventory inventory = GeneratorsGUI.generateInventory();

    public static void onClick(int slot, Player player, Inventory inv, VerseGUI.Type type) {
        if (type == VerseGUI.Type.CREATION_GUI) {
            if (!WorldCreationGUI.verseCreatorHashMap.containsKey(player.getUniqueId())) {
                return;
            }
            CustomGenerator gen = GeneratorsGUI.getGeneratorInSlot(slot);
            if (gen != null) {
                WorldCreationGUI.verseCreatorHashMap.get(player.getUniqueId()).chunkGenerator(gen);
                player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_YES, 1.0f, 1.0f);
            }
            player.closeInventory();
            WorldCreationGUI.openMainMenu(player);
        }
    }

    private static Inventory generateInventory() {
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)"All World Generators");
        List<CustomGenerator> generators = VerseGeneratorManager.getAllGenerators();
        int genericList = 18;
        int verseList = 0;
        for (CustomGenerator generator : generators) {
            Material icon = generator.getIcon();
            String readableName = generator.getReadableName();
            String ownerPlugin = generator.getName();
            int i = genericList;
            if (generator instanceof VerseGenerator) {
                readableName = Utils.GREEN_COLOR + "\u00a7l" + generator.getReadableName();
                i = verseList++;
                --genericList;
            }
            generatorHashMap.put(i, generator);
            inv.setItem(i, VerseGUI.simpleButton(icon, "\u00a7f" + readableName, Utils.GREEN_COLOR + "From Plugin: &f" + ownerPlugin, " ", "&eClick to select this world generator."));
            ++genericList;
        }
        ItemStack dividerIt = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
        ItemMeta im = dividerIt.getItemMeta();
        im.setDisplayName("");
        dividerIt.setItemMeta(im);
        for (int divider = 9; divider < 18; ++divider) {
            inv.setItem(divider, dividerIt);
        }
        return inv;
    }

    @Nullable
    public static CustomGenerator getGeneratorInSlot(int slot) {
        return generatorHashMap.getOrDefault(slot, null);
    }
}

