/*
 * Decompiled with CFR 0.152.
 */
package me.drawn.integrations.hooks;

import java.util.UUID;
import java.util.stream.Collectors;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.drawn.MegaVerse;
import me.drawn.management.VerseWorldManager;
import me.drawn.management.entities.VerseWorld;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PAPI
extends PlaceholderExpansion {
    @NotNull
    public String getAuthor() {
        return "MegaVerse";
    }

    @NotNull
    public String getIdentifier() {
        return "megaverse";
    }

    @NotNull
    public String getVersion() {
        return MegaVerse.getInstance().getDescription().getVersion();
    }

    public String onRequest(OfflinePlayer offlinePlayer, @NotNull String params) {
        if (offlinePlayer != null && offlinePlayer.hasPlayedBefore()) {
            Player player = Bukkit.getPlayer((UUID)offlinePlayer.getUniqueId());
            if (player == null) {
                return null;
            }
            if (params.equalsIgnoreCase("player_world_name")) {
                return player.getWorld().getName();
            }
            if (params.equalsIgnoreCase("player_world_seed")) {
                return String.valueOf(player.getWorld().getSeed());
            }
        }
        if (params.contains("info_")) {
            String[] worldNameAndOption = params.replace("info_", "").trim().split("\\_", 2);
            String worldName = worldNameAndOption[1];
            String option = worldNameAndOption[0].toLowerCase();
            VerseWorld world = VerseWorldManager.getVerseWorldByName(worldName);
            if (world == null) {
                return "World not found";
            }
            if (option.contains("generator")) {
                return world.getGenerator();
            }
            if (option.contains("seed")) {
                return String.valueOf(world.getSeed());
            }
            if (option.contains("name")) {
                return world.getName();
            }
            if (option.contains("time")) {
                return String.valueOf(world.getBukkitWorld().getTime());
            }
            if (option.contains("pvp")) {
                return String.valueOf(world.getBukkitWorld().getPVP());
            }
            if (option.contains("hardcore")) {
                return String.valueOf(world.getBukkitWorld().isHardcore());
            }
            if (option.contains("clearweather")) {
                return String.valueOf(world.getBukkitWorld().isClearWeather());
            }
            if (option.contains("viewdistance")) {
                return String.valueOf(world.getBukkitWorld().getViewDistance());
            }
            if (option.contains("simulationdistance")) {
                return String.valueOf(world.getBukkitWorld().getSimulationDistance());
            }
            if (option.contains("players")) {
                return world.getBukkitWorld().getPlayers().stream().map(Player::getDisplayName).collect(Collectors.joining(", "));
            }
            if (option.contains("playeramount")) {
                return String.valueOf(world.getBukkitWorld().getPlayers().size());
            }
        }
        return null;
    }
}

