/*
 * Decompiled with CFR 0.152.
 */
package me.drawn.management;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import me.drawn.MegaVerse;
import me.drawn.management.entities.VerseCreationOptions;
import me.drawn.management.entities.VerseWorld;
import me.drawn.management.flags.Flag;
import me.drawn.management.flags.FlagManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.generator.ChunkGenerator;

public class VerseWorldManager {
    private static final ArrayList<VerseWorld> verseWorlds = new ArrayList();
    public static final ArrayList<String> unloadedWorlds = new ArrayList();

    public static List<VerseWorld> getAllVerseWorlds() {
        return verseWorlds;
    }

    public static Location getSafeSpawnLocation(World world) {
        return world.getHighestBlockAt(world.getSpawnLocation()).getRelative(BlockFace.UP).getLocation();
    }

    public static boolean unloadWorld(World w) {
        World backupWorld = Bukkit.getWorld((String)"world");
        if (backupWorld == null) {
            List worlds = Bukkit.getWorlds();
            worlds.remove(w);
            Collections.shuffle(worlds);
            backupWorld = (World)worlds.get(0);
        }
        Location safe = VerseWorldManager.getSafeSpawnLocation(backupWorld);
        w.getPlayers().forEach(a -> a.teleport(safe));
        unloadedWorlds.add(w.getName());
        verseWorlds.remove(VerseWorldManager.getVerseWorldByWorld(w));
        return Bukkit.unloadWorld((World)w, (boolean)true);
    }

    @Nullable
    public static VerseWorld getVerseWorldByName(String name) {
        return verseWorlds.stream().filter(a -> name.equalsIgnoreCase(a.getName())).findFirst().orElse(null);
    }

    @Nullable
    public static VerseWorld getVerseWorldByWorld(World w) {
        return verseWorlds.stream().filter(a -> a.getBukkitWorld().equals(w)).findFirst().orElse(null);
    }

    public static Optional<VerseWorld> getVerseWorld(World w) {
        return Optional.ofNullable(VerseWorldManager.getVerseWorldByWorld(w));
    }

    private static void importDefaultWorlds() {
        for (World w : Bukkit.getWorlds()) {
            VerseWorldManager.registerNewWorld(w, null, true);
        }
    }

    public static void loadExistingWorlds() {
        VerseWorldManager.importDefaultWorlds();
        for (File file : Objects.requireNonNull(MegaVerse.worldConfigsFolder.listFiles())) {
            String worldName = file.getName().replace(".yml", "").trim();
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            MegaVerse.firstLog("Loading world " + worldName);
            File verseWorldFile = new File(Bukkit.getWorldContainer(), worldName);
            if (!verseWorldFile.exists()) {
                MegaVerse.secondLogError("World " + worldName + " could not be loaded, the world folder does not exist.");
                MegaVerse.secondLogError("Manually delete the config file '" + worldName + ".yml' inside world_configs folder in MegaVerse to stop seeing this message.");
                MegaVerse.empty();
                continue;
            }
            World w = null;
            try {
                if (!config.getBoolean("vanilla-world")) {
                    WorldType type;
                    MegaVerse.secondLog("World seed is " + config.getString("seed", "Unknown"));
                    MegaVerse.secondLog("Using world generator " + config.getString("generator", "Vanilla"));
                    WorldCreator creator = new WorldCreator(worldName);
                    if (config.contains("generator")) {
                        creator.generator(config.getString("generator"));
                    }
                    if (config.contains("environment")) {
                        creator.environment(World.Environment.valueOf((String)config.getString("environment", "NORMAL")));
                    }
                    if (config.contains("seed")) {
                        creator.seed(config.getLong("seed"));
                    }
                    if ((type = WorldType.getByName((String)config.getString("world-type", "NORMAL"))) != null) {
                        creator.type(type);
                    }
                    creator.generateStructures(config.getBoolean("options.generate-structures"));
                    creator.hardcore(config.getBoolean("options.hardcore"));
                    w = Bukkit.createWorld((WorldCreator)creator);
                } else {
                    w = Bukkit.getWorld((String)worldName);
                    MegaVerse.secondLog("Detected as a vanilla default world.");
                }
                MegaVerse.secondLog("Imported and loaded world " + worldName + " successfully!");
                VerseWorld verseWorld = new VerseWorld(worldName, w, file, config);
                verseWorlds.add(verseWorld);
            }
            catch (Exception ex) {
                MegaVerse.secondLogError("An error occurred while trying to load this world.");
                MegaVerse.secondLogError("More details: " + ex.getMessage());
                ex.fillInStackTrace();
            }
            MegaVerse.empty();
        }
    }

    private static void deleteWorldFileFromMegaverse(String worldName) {
        File f = new File(MegaVerse.worldConfigsFolder, worldName + ".yml");
        if (f.exists()) {
            f.delete();
        }
    }

    public static boolean deleteWorld(String worldName) {
        World world = Bukkit.getWorld((String)worldName);
        if (world != null) {
            return false;
        }
        VerseWorldManager.deleteWorldFileFromMegaverse(worldName);
        File worldFolder = new File(Bukkit.getWorldContainer(), worldName);
        return VerseWorldManager.deleteRecursively(worldFolder);
    }

    private static boolean deleteRecursively(File file) {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                if (VerseWorldManager.deleteRecursively(child)) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static String stringifyGenerator(ChunkGenerator generator) {
        return generator == null ? "VANILLA" : generator.toString();
    }

    private static VerseWorld registerNewWorld(World world, VerseCreationOptions creationOptions, boolean vanillaWorld) {
        YamlConfiguration config;
        File verseWorldFile = new File(MegaVerse.worldConfigsFolder, world.getName() + ".yml");
        if (!verseWorldFile.exists()) {
            try {
                verseWorldFile.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            config = YamlConfiguration.loadConfiguration((File)verseWorldFile);
            config.set("seed", (Object)String.valueOf(world.getSeed()));
            config.set("options.hardcore", (Object)world.isHardcore());
            if (creationOptions != null && creationOptions.hasChunkGenerator()) {
                config.set("generator", (Object)creationOptions.getGeneratorFullName());
            }
            config.set("world-type", (Object)world.getWorldType().name());
            config.set("environment", (Object)world.getEnvironment().toString());
            if (vanillaWorld) {
                config.set("vanilla-world", (Object)true);
            }
            config.set("options.difficulty", (Object)world.getDifficulty().name());
            for (Flag<?> flag : FlagManager.all()) {
                if (flag.getDefaultValue() == null) continue;
                config.set("flags." + flag.getId(), flag.getDefaultValue());
            }
            try {
                config.save(verseWorldFile);
            }
            catch (IOException ex) {
                ex.fillInStackTrace();
            }
        }
        config = YamlConfiguration.loadConfiguration((File)verseWorldFile);
        VerseWorld verseWorld = new VerseWorld(world.getName(), world, verseWorldFile, config);
        verseWorlds.add(verseWorld);
        return verseWorld;
    }

    public static List<String> getLoadedWorldsNames() {
        return Bukkit.getWorlds().stream().map(a -> a.getName()).collect(Collectors.toList());
    }

    public static void createWorld(VerseCreationOptions options, WorldCreationCallback callback) {
        try {
            World w = Bukkit.createWorld((WorldCreator)options.convertToWorldCreator());
            MegaVerse.log("&aCreated new MegaVerse world " + options.worldName());
            VerseWorld verseWorld = VerseWorldManager.registerNewWorld(w, options, false);
            callback.onWorldCreate(verseWorld);
            w.setKeepSpawnInMemory(verseWorld.getFlagValue(FlagManager.KEEP_SPAWN_IN_MEMORY).booleanValue());
        }
        catch (Exception ex) {
            callback.onError(ex);
        }
    }

    public static interface WorldCreationCallback {
        public void onWorldCreate(VerseWorld var1);

        public void onError(Exception var1);
    }
}

