/*
 * Decompiled with CFR 0.152.
 */
package me.drawn.management.entities;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import me.drawn.management.flags.Flag;
import me.drawn.management.flags.FlagManager;
import org.bukkit.Bukkit;
import org.bukkit.Difficulty;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class VerseWorld {
    private final String name;
    private final World bukkitWorld;
    private final YamlConfiguration configuration;
    private final File file;

    public VerseWorld(String name, World world, File file, YamlConfiguration config) {
        this.name = name;
        this.bukkitWorld = world;
        this.file = file;
        this.configuration = config;
    }

    public YamlConfiguration getConfiguration() {
        return this.configuration;
    }

    public <T> boolean isFlagSet(Flag<T> flag) {
        return this.configuration.contains("flags." + flag.getId());
    }

    @Nullable
    public <T> T getFlagValue(Flag<T> flag) {
        String path = "flags." + flag.getId();
        if (!this.configuration.contains(path)) {
            return flag.getDefaultValue();
        }
        switch (flag.getValueType()) {
            case BOOLEAN: {
                return (T)Boolean.valueOf(this.configuration.getBoolean(path));
            }
            case STRING: {
                return (T)this.configuration.getString(path);
            }
            case INTEGER: {
                return (T)Integer.valueOf(this.configuration.getInt(path));
            }
        }
        return flag.getDefaultValue();
    }

    public Map<String, Object> getFlagsAndValues() {
        HashMap<String, Object> flags = new HashMap<String, Object>();
        for (Flag<?> flag : FlagManager.all()) {
            Object object = this.configuration.get("flags." + flag.getId());
            if (object != null) {
                flags.put(flag.getId(), object);
                continue;
            }
            flags.put(flag.getId(), "Not yet defined");
        }
        return flags;
    }

    public <T> void setFlagValue(Flag<T> flag, T value) {
        this.configuration.set("flags." + flag.getId(), value);
        try {
            this.configuration.save(this.file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public File getFile() {
        return this.file;
    }

    public String getGenerator() {
        return this.configuration.getString("generator", "Vanilla");
    }

    public Difficulty getDifficulty() {
        return this.bukkitWorld.getDifficulty();
    }

    public long getSeed() {
        return this.bukkitWorld.getSeed();
    }

    public void teleport(Player player) {
        Location loc = this.bukkitWorld.getHighestBlockAt(this.bukkitWorld.getSpawnLocation()).getRelative(BlockFace.UP).getLocation();
        player.teleport(loc.add(0.5, 0.0, 0.5));
    }

    public String getName() {
        return this.name;
    }

    public World getBukkitWorld() {
        if (this.bukkitWorld == null) {
            return Bukkit.getWorld((String)this.name);
        }
        return this.bukkitWorld;
    }
}

