/*
 * Decompiled with CFR 0.152.
 */
package me.drawn.management.flags;

import me.drawn.management.VerseWorldManager;
import me.drawn.management.flags.FlagManager;
import me.drawn.utils.Utils;
import org.bukkit.GameMode;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.bukkit.event.world.PortalCreateEvent;

public class FlagEvents
implements Listener {
    @EventHandler
    public void onDamage(EntityDamageByEntityEvent e) {
        if (e.getDamager().getType() == EntityType.PLAYER && e.getEntity().getType() == EntityType.PLAYER) {
            VerseWorldManager.getVerseWorld(e.getEntity().getWorld()).ifPresent(verseWorld -> {
                Player attacker = (Player)e.getDamager();
                if (!verseWorld.getFlagValue(FlagManager.PVP).booleanValue() && !attacker.hasPermission("megaverse.bypass.flag.pvp")) {
                    e.setCancelled(true);
                }
            });
        }
    }

    @EventHandler
    public void onPortal(PortalCreateEvent e) {
        VerseWorldManager.getVerseWorld(e.getWorld()).ifPresent(verseWorld -> {
            if (!verseWorld.getFlagValue(FlagManager.PORTAL_FORMATION).booleanValue()) {
                e.setCancelled(true);
            }
        });
    }

    @EventHandler
    public void onWeather(WeatherChangeEvent e) {
        VerseWorldManager.getVerseWorld(e.getWorld()).ifPresent(verseWorld -> {
            if (!verseWorld.getFlagValue(FlagManager.ALLOW_WEATHER_CHANGES).booleanValue()) {
                e.setCancelled(true);
            }
        });
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        VerseWorldManager.getVerseWorld(p.getWorld()).ifPresent(verseWorld -> {
            String serverJoinMessage;
            if (verseWorld.isFlagSet(FlagManager.SERVER_JOIN_MESSAGE) && (serverJoinMessage = verseWorld.getFlagValue(FlagManager.SERVER_JOIN_MESSAGE)) != null && !serverJoinMessage.isEmpty()) {
                e.setJoinMessage(Utils.c(serverJoinMessage.replace("%player%", p.getDisplayName())));
            }
        });
    }

    @EventHandler
    public void onGlide(EntityToggleGlideEvent e) {
        VerseWorldManager.getVerseWorld(e.getEntity().getWorld()).ifPresent(verseWorld -> {
            boolean allowElytras;
            if (verseWorld.isFlagSet(FlagManager.ALLOW_ELYTRAS) && !(allowElytras = verseWorld.getFlagValue(FlagManager.ALLOW_ELYTRAS).booleanValue())) {
                e.setCancelled(true);
            }
        });
    }

    @EventHandler
    public void onWorld(PlayerChangedWorldEvent e) {
        Player player = e.getPlayer();
        World world = player.getWorld();
        World from = e.getFrom();
        VerseWorldManager.getVerseWorld(world).ifPresent(verseWorld -> {
            String messageOnEnter;
            String titleOnEnter;
            boolean fullhealOnEnter;
            String soundOnEnter;
            GameMode gameMode;
            if (verseWorld.isFlagSet(FlagManager.GAMEMODE) && (gameMode = GameMode.getByValue((int)verseWorld.getFlagValue(FlagManager.GAMEMODE))) != null) {
                player.setGameMode(gameMode);
            }
            if (verseWorld.isFlagSet(FlagManager.SOUND_ON_ENTER) && (soundOnEnter = verseWorld.getFlagValue(FlagManager.SOUND_ON_ENTER)) != null && !soundOnEnter.isEmpty()) {
                player.playSound(player.getLocation(), soundOnEnter, 0.75f, 1.0f);
            }
            if (verseWorld.isFlagSet(FlagManager.FULLHEAL_ON_ENTER) && (fullhealOnEnter = verseWorld.getFlagValue(FlagManager.FULLHEAL_ON_ENTER).booleanValue())) {
                player.setHealth(player.getMaxHealth());
            }
            if (verseWorld.isFlagSet(FlagManager.TITLE_ON_ENTER) && (titleOnEnter = verseWorld.getFlagValue(FlagManager.TITLE_ON_ENTER)) != null && !titleOnEnter.isEmpty()) {
                String[] title = titleOnEnter.split("\\\\n");
                if (title.length >= 2) {
                    player.sendTitle(Utils.c(title[0]), Utils.c(title[1]), 20, 20, 20);
                } else {
                    player.sendTitle(Utils.c(titleOnEnter), "", 20, 20, 20);
                }
            }
            if (verseWorld.isFlagSet(FlagManager.MESSAGE_ON_ENTER) && (messageOnEnter = verseWorld.getFlagValue(FlagManager.MESSAGE_ON_ENTER)) != null && !messageOnEnter.isEmpty()) {
                player.sendMessage(Utils.c(messageOnEnter));
            }
        });
        VerseWorldManager.getVerseWorld(from).ifPresent(verseWorld -> {
            String soundOnLeave;
            if (verseWorld.isFlagSet(FlagManager.SOUND_ON_LEAVE) && (soundOnLeave = verseWorld.getFlagValue(FlagManager.SOUND_ON_LEAVE)) != null && !soundOnLeave.isEmpty()) {
                player.playSound(player.getLocation(), soundOnLeave, 1.0f, 1.0f);
            }
        });
    }
}

