/*
 * Decompiled with CFR 0.152.
 */
package me.drawn.management.flags;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.drawn.management.flags.Flag;

public class FlagManager {
    private static final Map<String, Flag<?>> registeredFlags = new HashMap();
    public static final Flag<Boolean> PVP = new Flag<Boolean>("pvp", true, ValueType.BOOLEAN);
    public static final Flag<Boolean> ALLOW_WEATHER_CHANGES = new Flag<Boolean>("allow-weather-changes", true, ValueType.BOOLEAN);
    public static final Flag<Boolean> KEEP_SPAWN_IN_MEMORY = new Flag<Boolean>("keep-spawn-in-memory", false, ValueType.BOOLEAN);
    public static final Flag<Boolean> PORTAL_FORMATION = new Flag<Boolean>("portal-formation", true, ValueType.BOOLEAN);
    public static final Flag<Integer> GAMEMODE = new Flag<Object>("gamemode", null, ValueType.INTEGER);
    public static final Flag<String> TITLE_ON_ENTER = new Flag<Object>("title-on-enter", null, ValueType.STRING);
    public static final Flag<String> MESSAGE_ON_ENTER = new Flag<Object>("message-on-enter", null, ValueType.STRING);
    public static final Flag<String> SERVER_JOIN_MESSAGE = new Flag<Object>("server-join-message", null, ValueType.STRING);
    public static final Flag<Boolean> ALLOW_FLYING = new Flag<Object>("allow-flying", null, ValueType.BOOLEAN);
    public static final Flag<Boolean> FORCE_FLYING_STATUS = new Flag<Object>("force-flying-status", null, ValueType.BOOLEAN);
    public static final Flag<Boolean> ALLOW_ELYTRAS = new Flag<Boolean>("allow-elytras", true, ValueType.BOOLEAN);
    public static final Flag<Boolean> ALLOW_HUNGER = new Flag<Boolean>("allow-hunger", true, ValueType.BOOLEAN);
    public static final Flag<String> SOUND_ON_ENTER = new Flag<String>("sound-on-enter", "entity.experience_orb.pickup", ValueType.STRING);
    public static final Flag<String> SOUND_ON_LEAVE = new Flag<Object>("sound-on-leave", null, ValueType.STRING);
    public static final Flag<Boolean> FULLHEAL_ON_ENTER = new Flag<Boolean>("fullheal-on-enter", false, ValueType.BOOLEAN);

    public static void register(Flag<?> flag) {
        registeredFlags.put(flag.getId().toLowerCase(), flag);
    }

    public static List<String> allFlagIds() {
        return FlagManager.all().stream().map(Flag::getId).collect(Collectors.toList());
    }

    public static Flag<?> get(String id) {
        return registeredFlags.get(id.toLowerCase());
    }

    public static Collection<Flag<?>> all() {
        return registeredFlags.values();
    }

    public static enum ValueType {
        STRING,
        BOOLEAN,
        INTEGER;


        public Object parse(String raw) {
            switch (this) {
                case STRING: {
                    return raw;
                }
                case BOOLEAN: {
                    return Boolean.parseBoolean(raw);
                }
                case INTEGER: {
                    return Integer.parseInt(raw);
                }
            }
            throw new IllegalArgumentException("Unknown value type");
        }
    }
}

