/*
 * Decompiled with CFR 0.152.
 */
package me.drawn.management.flags;

import java.util.List;
import me.drawn.management.VerseWorldManager;
import me.drawn.management.entities.VerseWorld;
import me.drawn.management.flags.FlagManager;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class FlagRunnable
extends BukkitRunnable {
    public void run() {
        for (VerseWorld verseWorld : VerseWorldManager.getAllVerseWorlds()) {
            if (verseWorld == null || verseWorld.getBukkitWorld() == null) continue;
            List playerList = verseWorld.getBukkitWorld().getPlayers();
            for (Player player : playerList) {
                boolean allowHunger;
                if (player.isDead() || !player.isOnline()) continue;
                if (verseWorld.isFlagSet(FlagManager.ALLOW_FLYING)) {
                    boolean allowFlying = verseWorld.getFlagValue(FlagManager.ALLOW_FLYING);
                    player.setAllowFlight(allowFlying);
                }
                if (verseWorld.isFlagSet(FlagManager.ALLOW_HUNGER) && !(allowHunger = verseWorld.getFlagValue(FlagManager.ALLOW_HUNGER).booleanValue())) {
                    player.setFoodLevel(20);
                }
                if (!verseWorld.isFlagSet(FlagManager.FORCE_FLYING_STATUS)) continue;
                boolean forceFlying = verseWorld.getFlagValue(FlagManager.FORCE_FLYING_STATUS);
                player.setFlying(forceFlying);
            }
        }
    }
}

