/*
 * Decompiled with CFR 0.152.
 */
package me.drawn.management.generators;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import me.drawn.MegaVerse;
import me.drawn.management.entities.VerseGenerator;
import me.drawn.utils.noises.FastNoiseLite;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.LimitedRegion;
import org.bukkit.generator.WorldInfo;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApocalypticGenerator
extends VerseGenerator {
    public ApocalypticGenerator() {
        super((Plugin)MegaVerse.getInstance(), "apocalyptic_generator", "Apocalyptic Generator", new BukkitApocalypticGenerator(), Material.DEAD_BUSH);
    }

    public static class BukkitApocalypticGenerator
    extends ChunkGenerator {
        private final FastNoiseLite terrainNoise = new FastNoiseLite();
        private final FastNoiseLite biomeNoise;
        private ApocalypticBiomeProvider biomeProvider;

        public boolean shouldGenerateCaves() {
            return true;
        }

        public BukkitApocalypticGenerator() {
            this.terrainNoise.SetNoiseType(FastNoiseLite.NoiseType.OpenSimplex2);
            this.terrainNoise.SetFrequency(0.005f);
            this.terrainNoise.SetFractalType(FastNoiseLite.FractalType.FBm);
            this.terrainNoise.SetFractalOctaves(5);
            this.terrainNoise.SetFractalLacunarity(2.0f);
            this.terrainNoise.SetFractalGain(0.5f);
            this.biomeNoise = new FastNoiseLite();
            this.biomeNoise.SetNoiseType(FastNoiseLite.NoiseType.Cellular);
            this.biomeNoise.SetFrequency(0.002f);
            this.biomeNoise.SetCellularDistanceFunction(FastNoiseLite.CellularDistanceFunction.EuclideanSq);
            this.biomeNoise.SetCellularReturnType(FastNoiseLite.CellularReturnType.CellValue);
        }

        public void generateNoise(@NotNull WorldInfo worldInfo, @NotNull Random random, int chunkX, int chunkZ, @NotNull ChunkGenerator.ChunkData chunkData) {
            for (int x = 0; x < 16; ++x) {
                int worldX = chunkX * 16 + x;
                for (int z = 0; z < 16; ++z) {
                    Material surfaceBlock;
                    float noiseAmplitude;
                    int baseHeight;
                    int worldZ = chunkZ * 16 + z;
                    float biomeValue = this.biomeNoise.GetNoise(worldX, worldZ);
                    if (biomeValue < -0.3f) {
                        baseHeight = 60;
                        noiseAmplitude = 40.0f;
                        surfaceBlock = random.nextBoolean() ? (random.nextBoolean() ? Material.MAGMA_BLOCK : Material.BASALT) : Material.BLACKSTONE;
                    } else if (biomeValue < 0.3f) {
                        baseHeight = 70;
                        noiseAmplitude = 20.0f;
                        surfaceBlock = Material.COARSE_DIRT;
                    } else {
                        baseHeight = 70;
                        noiseAmplitude = 5.0f;
                        surfaceBlock = Material.PODZOL;
                    }
                    float terrainNoiseValue = this.terrainNoise.GetNoise(worldX, worldZ);
                    int terrainHeight = (int)((float)baseHeight + terrainNoiseValue * noiseAmplitude);
                    for (int y = worldInfo.getMinHeight(); y <= terrainHeight; ++y) {
                        if (y == terrainHeight) {
                            chunkData.setBlock(x, y, z, surfaceBlock);
                            continue;
                        }
                        if (y > terrainHeight - 4) {
                            chunkData.setBlock(x, y, z, Material.DIRT);
                            continue;
                        }
                        chunkData.setBlock(x, y, z, Material.STONE);
                    }
                    chunkData.setBlock(x, worldInfo.getMinHeight(), z, Material.BEDROCK);
                }
            }
        }

        @Nullable
        public BiomeProvider getDefaultBiomeProvider(@NotNull WorldInfo worldInfo) {
            if (this.biomeProvider == null) {
                this.biomeProvider = new ApocalypticBiomeProvider(this.biomeNoise);
            }
            return this.biomeProvider;
        }

        @NotNull
        public List<BlockPopulator> getDefaultPopulators(@NotNull World world) {
            return Collections.singletonList(new DeadTreePopulator());
        }

        private static class DeadTreePopulator
        extends BlockPopulator {
            private final FastNoiseLite treeNoise = new FastNoiseLite();

            public DeadTreePopulator() {
                this.treeNoise.SetNoiseType(FastNoiseLite.NoiseType.OpenSimplex2);
                this.treeNoise.SetFrequency(0.1f);
            }

            public void populate(@NotNull WorldInfo worldInfo, @NotNull Random random, int chunkX, int chunkZ, @NotNull LimitedRegion limitedRegion) {
                for (int x = 0; x < 16; ++x) {
                    int worldX = chunkX * 16 + x;
                    for (int z = 0; z < 16; ++z) {
                        Material type;
                        int yBelow;
                        int y;
                        int worldZ = chunkZ * 16 + z;
                        Biome biome = limitedRegion.getBiome(worldX, 64, worldZ);
                        float treeValue = this.treeNoise.GetNoise(worldX, worldZ);
                        double treeChance = -1.0;
                        double bushChance = -1.0;
                        if (biome == Biome.WINDSWEPT_SAVANNA) {
                            treeChance = 0.8;
                            bushChance = 0.7;
                        } else if (biome == Biome.PLAINS) {
                            treeChance = 0.95;
                            bushChance = 0.4;
                        }
                        if ((double)treeValue > treeChance) {
                            y = limitedRegion.getHighestBlockYAt(worldX, worldZ);
                            yBelow = y - 1;
                            type = limitedRegion.getType(worldX, yBelow, worldZ);
                            if (y <= 0 || type != Material.PODZOL && type != Material.COARSE_DIRT) continue;
                            this.generateDeadTree(limitedRegion, random, worldX, y, worldZ);
                            continue;
                        }
                        if (!((double)treeValue > bushChance)) continue;
                        y = limitedRegion.getHighestBlockYAt(worldX, worldZ);
                        yBelow = y - 1;
                        type = limitedRegion.getType(worldX, yBelow, worldZ);
                        if (y <= 0 || type != Material.PODZOL && type != Material.COARSE_DIRT) continue;
                        limitedRegion.setType(worldX, y, worldZ, Material.DEAD_BUSH);
                    }
                }
            }

            private void generateDeadTree(LimitedRegion region, Random random, int x, int y, int z) {
                int height = random.nextInt(3) + 4;
                for (int i = 0; i < height; ++i) {
                    if (!region.isInRegion(x, y + i, z)) continue;
                    region.setType(x, y + i, z, Material.OAK_LOG);
                }
                if (random.nextBoolean() && region.isInRegion(x + 1, y + height - 2, z)) {
                    region.setType(x + 1, y + height - 2, z, Material.OAK_FENCE);
                }
                if (random.nextBoolean() && region.isInRegion(x - 1, y + height - 1, z)) {
                    region.setType(x - 1, y + height - 1, z, Material.OAK_FENCE);
                }
                if (random.nextBoolean() && region.isInRegion(x, y + height - 1, z + 1)) {
                    region.setType(x, y + height - 1, z + 1, Material.OAK_FENCE);
                }
            }

            private int getHighestY(LimitedRegion region, int x, int z) {
                for (int y = region.getHighestBlockYAt(x, z); y > region.getBuffer(); --y) {
                    if (!region.getType(x, y, z).isSolid()) continue;
                    return y;
                }
                return -1;
            }
        }

        private static class ApocalypticBiomeProvider
        extends BiomeProvider {
            private final FastNoiseLite biomeNoise;

            public ApocalypticBiomeProvider(FastNoiseLite biomeNoise) {
                this.biomeNoise = biomeNoise;
            }

            @NotNull
            public Biome getBiome(@NotNull WorldInfo worldInfo, int x, int y, int z) {
                float biomeValue = this.biomeNoise.GetNoise(x, z);
                if (biomeValue < -0.3f) {
                    return Biome.BASALT_DELTAS;
                }
                if (biomeValue < 0.3f) {
                    return Biome.WINDSWEPT_SAVANNA;
                }
                return Biome.PLAINS;
            }

            @NotNull
            public List<Biome> getBiomes(@NotNull WorldInfo worldInfo) {
                return Arrays.asList(Biome.BASALT_DELTAS, Biome.WINDSWEPT_SAVANNA, Biome.PLAINS);
            }
        }
    }
}

