/*
 * Decompiled with CFR 0.152.
 */
package me.drawn.management.generators;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import me.drawn.MegaVerse;
import me.drawn.management.entities.VerseGenerator;
import me.drawn.utils.noises.FastNoiseLite;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.plugin.Plugin;

public class FarLandsGenerator
extends VerseGenerator {
    public FarLandsGenerator() {
        super((Plugin)MegaVerse.getInstance(), "farlands_generator", "Far Lands Generator", new BukkitFarLandsGenerator(), Material.ENDER_EYE);
    }

    public static final class BukkitFarLandsGenerator
    extends ChunkGenerator {
        private final FastNoiseLite noise;
        private final double frequency = 0.015;
        private final double densityThreshold = 0.0;
        private final int minIslandY = 40;
        private final int maxIslandY = 160;
        private final int dirtLayerDepth = 3;
        final Material topMaterial = Material.GRASS_BLOCK;
        final Material belowTopMaterial = Material.DIRT;

        public BukkitFarLandsGenerator() {
            this.noise = new FastNoiseLite();
            this.noise.SetNoiseType(FastNoiseLite.NoiseType.OpenSimplex2);
            this.noise.SetFrequency(0.015f);
            this.noise.SetFractalType(FastNoiseLite.FractalType.FBm);
            this.noise.SetFractalOctaves(4);
            this.noise.SetFractalLacunarity(2.0f);
            this.noise.SetFractalGain(0.5f);
        }

        public void generateNoise(WorldInfo worldInfo, Random random, int chunkX, int chunkZ, ChunkGenerator.ChunkData chunkData) {
            for (int y = 40; y <= 160; ++y) {
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        double verticalCenter;
                        double distanceFactor;
                        double verticalBias;
                        int worldX = chunkX * 16 + x;
                        int worldY = y;
                        int worldZ = chunkZ * 16 + z;
                        float noiseValue = this.noise.GetNoise(worldX, worldY, worldZ);
                        double effectiveDensity = (double)noiseValue * (verticalBias = 1.0 - (distanceFactor = Math.abs((double)worldY - (verticalCenter = 100.0)) / (verticalCenter - 40.0)) * 0.8);
                        if (!(effectiveDensity > 0.0)) continue;
                        chunkData.setBlock(x, y, z, Material.STONE);
                    }
                }
            }
        }

        public void generateSurface(WorldInfo worldInfo, Random random, int chunkX, int chunkZ, ChunkGenerator.ChunkData chunkData) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    int currentY;
                    int highestY = -1;
                    for (int y = 160; y >= 40; --y) {
                        if (chunkData.getType(x, y, z) == Material.AIR) continue;
                        highestY = y;
                        break;
                    }
                    if (highestY == -1) continue;
                    chunkData.setBlock(x, highestY, z, this.topMaterial);
                    for (int i = 1; i <= 3 && (currentY = highestY - i) >= 40 && chunkData.getType(x, currentY, z) != Material.AIR; ++i) {
                        if (chunkData.getType(x, currentY, z) != Material.STONE) continue;
                        chunkData.setBlock(x, currentY, z, this.belowTopMaterial);
                    }
                }
            }
        }

        public void generateBedrock(WorldInfo worldInfo, Random random, int chunkX, int chunkZ, ChunkGenerator.ChunkData chunkData) {
        }

        public BiomeProvider getDefaultBiomeProvider(WorldInfo worldInfo) {
            return new BiomeProvider(){

                public Biome getBiome(WorldInfo worldInfo, int x, int y, int z) {
                    return Biome.PLAINS;
                }

                public List<Biome> getBiomes(WorldInfo worldInfo) {
                    return Arrays.asList(Biome.PLAINS);
                }
            };
        }

        public boolean shouldGenerateNoise() {
            return true;
        }

        public boolean shouldGenerateSurface() {
            return true;
        }

        public boolean shouldGenerateBedrock() {
            return false;
        }

        public boolean shouldGenerateCaves() {
            return false;
        }

        public boolean shouldGenerateDecorations() {
            return true;
        }

        public boolean shouldGenerateMobs() {
            return true;
        }

        public boolean shouldGenerateStructures() {
            return true;
        }
    }
}

