/*
 * Decompiled with CFR 0.152.
 */
package me.drawn.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Scanner;
import java.util.function.Consumer;
import me.drawn.MegaVerse;
import me.drawn.utils.ServerVersion;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class Utils {
    public static final String WARNING_COLOR = ServerVersion.newerThan1_16 ? net.md_5.bungee.api.ChatColor.of((String)"#c74242") + "" : "\u00a7c";
    public static final String GREEN_HEX = "#a5fc42";
    public static final String GREEN_COLOR = ServerVersion.newerThan1_16 ? net.md_5.bungee.api.ChatColor.of((String)"#a5fc42") + "" : "\u00a7a";
    public static final String DARK_GREEN_HEX = "#518022";
    public static final String DARK_GREEN_COLOR = ServerVersion.newerThan1_16 ? net.md_5.bungee.api.ChatColor.of((String)"#518022") + "" : "\u00a72";

    public static String c(String s) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)s);
    }

    public static String getWarningSymbol() {
        return WARNING_COLOR + "\u26a0 ";
    }

    public static void formalPlayerWarning(CommandSender sender, String warning) {
        sender.sendMessage(Utils.getWarningSymbol() + "\u00a7lMegaVerse \u00a78\u2192 " + Utils.c(WARNING_COLOR + warning));
    }

    public static void normalMessage(CommandSender sender, String message) {
        sender.sendMessage(Utils.getPrefix() + Utils.c(message));
    }

    public static void incorrectUsage(CommandSender sender, String correctUsage) {
        sender.sendMessage(Utils.getWarningSymbol() + Utils.c("Correct usage: " + correctUsage));
    }

    public static void checkUpdates(Consumer<String> consumer) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)MegaVerse.getInstance(), () -> {
            try (InputStream is = new URL("https://api.spigotmc.org/legacy/update.php?resource=124726/~").openStream();
                 Scanner scann = new Scanner(is);){
                if (scann.hasNext()) {
                    consumer.accept(scann.next());
                }
            }
            catch (IOException e) {
                MegaVerse.log("&cAn error occurred while checking for updates.");
                e.fillInStackTrace();
            }
        });
    }

    public static String getPrefix() {
        return GREEN_COLOR + "\ud83c\udf0d \u00a7lMegaVerse \u00a77\u2192 \u00a7f";
    }

    public static void awaitChatInput(final Player player, final ChatInputCallback callback) {
        player.sendTitle(GREEN_COLOR + "Write in chat", "\u00a77Type 'cancel' to quit!", 5, 60, 20);
        player.closeInventory();
        Listener listener = new Listener(){

            @EventHandler(ignoreCancelled=false, priority=EventPriority.LOWEST)
            public void onChat(AsyncPlayerChatEvent e) {
                Bukkit.getScheduler().runTask((Plugin)MegaVerse.getInstance(), () -> {
                    if (!e.getPlayer().equals(player)) {
                        return;
                    }
                    String msg = e.getMessage();
                    switch (msg.toLowerCase()) {
                        case "cancel": 
                        case "quit": 
                        case "leave": 
                        case "back": {
                            callback.onCancel();
                            e.getPlayer().sendMessage(ChatColor.RED + "Cancelling chat input.");
                            AsyncPlayerChatEvent.getHandlerList().unregister((Listener)this);
                            return;
                        }
                    }
                    AsyncPlayerChatEvent.getHandlerList().unregister((Listener)this);
                    callback.onInput(Utils.c(msg));
                });
            }
        };
        Bukkit.getServer().getPluginManager().registerEvents(listener, (Plugin)MegaVerse.getInstance());
    }

    public static interface ChatInputCallback {
        public void onInput(String var1);

        public void onCancel();
    }
}

