/*
 * Decompiled with CFR 0.152.
 */
package me.paulferlitz.IO;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import me.paulferlitz.IO.Compression_Types;

public class NBTFileHandler {
    public static DataInputStream loadNBTToReader(File file) throws IOException {
        InputStream fileStream;
        if (Files.notExists(file.toPath(), new LinkOption[0])) {
            throw new FileNotFoundException(String.format("The file %s doesn't exist!", file.getPath()));
        }
        switch (NBTFileHandler.getCompressionType(file)) {
            case NONE: {
                fileStream = new FileInputStream(file);
                break;
            }
            case GZIP: {
                fileStream = new GZIPInputStream(new FileInputStream(file));
                break;
            }
            case ZLIB: {
                fileStream = new InflaterInputStream(new FileInputStream(file));
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("The file %s is compressed with an unsupported format!", file.getName()));
            }
        }
        return new DataInputStream(fileStream);
    }

    public static Compression_Types getCompressionType(File file) {
        if (NBTFileHandler.isGzipped(file)) {
            return Compression_Types.GZIP;
        }
        if (NBTFileHandler.isZlibed(file)) {
            return Compression_Types.ZLIB;
        }
        if (NBTFileHandler.isLZ4ed(file)) {
            return Compression_Types.LZ4;
        }
        return Compression_Types.NONE;
    }

    private static boolean isGzipped(File file) {
        try {
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            int magic = raf.read() & 0xFF | raf.read() << 8 & 0xFF00;
            raf.close();
            return magic == 35615;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean isZlibed(File file) {
        try {
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            int magic = raf.read() & 0xFF | raf.read() << 8 & 0xFF00;
            raf.close();
            return (magic & 0xF00) == 2048;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean isLZ4ed(File file) {
        return false;
    }
}

