/*
 * Decompiled with CFR 0.152.
 */
package me.paulferlitz.NBTTags;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import me.paulferlitz.NBTTags.Tag;
import me.paulferlitz.NBTTags.Tag_List;

public class Collection_Tag
extends Tag<ArrayList<Tag<?>>> {
    public Collection_Tag(int id) {
        super(id);
    }

    public Collection_Tag(int id, String name) {
        super(id, name);
    }

    public Collection_Tag(int id, String name, ArrayList<Tag<?>> data) {
        super(id, name, data);
    }

    public void addTag(Tag<?> tag) {
        this.addAllTags(List.of(tag));
    }

    public void addAllTags(List<Tag<?>> tags) {
        if (this instanceof Tag_List) {
            Tag_List list = (Tag_List)this;
            for (Tag<?> tag : tags) {
                if (tag.getId() == list.getListTypeID()) continue;
                throw new IllegalArgumentException(String.format("Mixed datatypes!. Expected %d but got %d", this.getId(), tag.getId()));
            }
        }
        ((ArrayList)this.getData()).addAll(tags);
    }

    public List<Tag<?>> getAllTagsByName(String name) {
        return this.getTagsByName(name, true);
    }

    public Tag<?> getTagByName(String name) {
        return this.getTagsByName(name, false).stream().findFirst().orElse(null);
    }

    private List<Tag<?>> getTagsByName(String name, boolean global) {
        ArrayList tags = new ArrayList();
        for (Tag tag : (ArrayList)this.getData()) {
            if (tag.getName().equals(name)) {
                tags.add(tag);
                if (global) continue;
                return tags;
            }
            if (!(tag instanceof Collection_Tag)) continue;
            Collection_Tag collectionTag = (Collection_Tag)tag;
            tags.addAll(collectionTag.getTagsByName(name, global));
        }
        return tags;
    }

    public List<Tag<?>> getAllTags(Tag<?> targetTag) {
        return this.getTags(targetTag, true);
    }

    public Tag<?> getTag(Tag<?> targetTag) {
        return this.getTags(targetTag, false).stream().findFirst().orElse(null);
    }

    private List<Tag<?>> getTags(Tag<?> targetTag, boolean global) {
        ArrayList tags = new ArrayList();
        for (Tag tag : (ArrayList)this.getData()) {
            if (tag.equals(targetTag)) {
                tags.add(tag);
                if (global) continue;
                return tags;
            }
            if (!(tag instanceof Collection_Tag)) continue;
            Collection_Tag collectionTag = (Collection_Tag)tag;
            tags.addAll(collectionTag.getTags(targetTag, global));
        }
        return tags;
    }

    public void removeAllTagsByName(String name) {
        this.removeTagsByName(name, true);
    }

    public void removeTagByName(String name) {
        this.removeTagsByName(name, false);
    }

    private void removeTagsByName(String name, boolean global) {
        Iterator iterator = ((ArrayList)this.getData()).iterator();
        while (iterator.hasNext()) {
            Tag tag = (Tag)iterator.next();
            if (tag.getName().equals(name)) {
                iterator.remove();
                if (global) continue;
                return;
            }
            if (!(tag instanceof Collection_Tag)) continue;
            Collection_Tag collectionTag = (Collection_Tag)tag;
            collectionTag.removeTagsByName(name, global);
        }
    }

    public void removeAllTags(Tag<?> targetTag) {
        this.removeTags(targetTag, true);
    }

    public void removeTag(Tag<?> targetTag) {
        this.removeTags(targetTag, false);
    }

    private void removeTags(Tag<?> targetTag, boolean global) {
        Iterator iterator = ((ArrayList)this.getData()).iterator();
        while (iterator.hasNext()) {
            Tag tag = (Tag)iterator.next();
            if (tag.equals(targetTag)) {
                iterator.remove();
                if (global) continue;
                return;
            }
            if (!(tag instanceof Collection_Tag)) continue;
            Collection_Tag collectionTag = (Collection_Tag)tag;
            collectionTag.removeTags(targetTag, global);
        }
    }
}

