/*
 * Decompiled with CFR 0.152.
 */
package me.drawn.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import me.drawn.MegaVerse;
import me.drawn.gui.custom.WorldCreationGUI;
import me.drawn.gui.custom.WorldImportGUI;
import me.drawn.management.VerseWorldManager;
import me.drawn.management.entities.VerseWorld;
import me.drawn.management.flags.Flag;
import me.drawn.management.flags.FlagManager;
import me.drawn.utils.Utils;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MainCommand
implements CommandExecutor {
    public static final List<String> SUB_COMMANDS = Arrays.asList("create", "version", "info", "who", "flag", "list", "tp", "import", "unload", "delete");
    public static final List<String> FLAG_SUB_COMMANDS = Arrays.asList("set", "remove", "info");
    private static final List<String> confirmDelete = new ArrayList<String>();
    public static final String divider = Utils.GREEN_COLOR + "\u204e \u00a77\u00a7m                                   \u00a7r " + Utils.GREEN_COLOR + "\u204e";

    public static void sendWorldActionsComponent(CommandSender s, World world) {
        String worldName = world.getName();
        TextComponent component = new TextComponent("\u2302 " + world.getName());
        component.setColor(ChatColor.of((String)"#a5fc42"));
        TextComponent separator = new TextComponent(" - ");
        separator.setColor(ChatColor.WHITE);
        component.addExtra((BaseComponent)separator);
        TextComponent infoAction = new TextComponent(" [\u24d8 INFO]");
        infoAction.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/megaverse info " + worldName));
        infoAction.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text("\u00a77Click to view world info.")}));
        infoAction.setColor(ChatColor.GOLD);
        TextComponent tpAction = new TextComponent(" [\ud83c\udf0d TP]");
        tpAction.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/megaverse tp " + worldName));
        tpAction.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text("\u00a77Click to teleport to this world.")}));
        tpAction.setColor(ChatColor.AQUA);
        TextComponent unloadAction = new TextComponent(" [\u24e7 UNLOAD]");
        unloadAction.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/megaverse unload " + worldName));
        unloadAction.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text("\u00a77Click to unload this world.\n\u00a77Unloading the world will not delete it,\n\u00a77in order to \u00a7cpermanently \u00a77delete, use '/megaverse delete' command.")}));
        unloadAction.setColor(ChatColor.GRAY);
        component.addExtra((BaseComponent)infoAction);
        component.addExtra((BaseComponent)tpAction);
        component.addExtra((BaseComponent)unloadAction);
        s.spigot().sendMessage((BaseComponent)component);
    }

    public static void sendClipboardWorldInfo(CommandSender s, String name, String value) {
        TextComponent baseComponent = new TextComponent(name);
        baseComponent.setColor(ChatColor.of((String)"#a5fc42"));
        TextComponent divider = new TextComponent(": ");
        divider.setColor(ChatColor.GRAY);
        TextComponent clipboard = new TextComponent(value);
        clipboard.setColor(ChatColor.WHITE);
        clipboard.setItalic(Boolean.valueOf(true));
        clipboard.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text("\u00a77Click to Copy to Clipboard")}));
        clipboard.setClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, value));
        baseComponent.addExtra((BaseComponent)divider);
        baseComponent.addExtra((BaseComponent)clipboard);
        s.spigot().sendMessage((BaseComponent)baseComponent);
    }

    private static void sendRunningMessages(CommandSender s) {
        s.sendMessage(divider);
        s.sendMessage(Utils.getPrefix() + "Running MegaVerse v" + MegaVerse.getInstance().getDescription().getVersion());
        if (!MegaVerse.pluginUpdated) {
            Utils.formalPlayerWarning(s, "You are running an outdated version! You can download the latest plugin version at \u00a7nhttps://modrinth.com/plugin/megaverse");
        }
        s.sendMessage(divider);
    }

    public boolean onCommand(CommandSender s, Command cmd, String label, String[] args) {
        String worldName;
        World w;
        if (s instanceof Player) {
            Player p = (Player)s;
            p.playSound(p.getLocation(), "entity.villager.work_cartographer", 1.0f, 1.0f);
        }
        if (args.length == 0) {
            MainCommand.sendRunningMessages(s);
            s.sendMessage(Utils.c(Utils.GREEN_COLOR + "/megaverse tp <world> [player] &7- Teleports a player/you to the specified world.\n" + Utils.GREEN_COLOR + "/megaverse who [world] &7- Lists all online players on a specific world\n" + Utils.GREEN_COLOR + "/megaverse info [world] &7- View detailed info about a world.\n" + Utils.GREEN_COLOR + "/megaverse version &7- Shows you the current plugin version (and if the plugin is outdated).\n" + Utils.GREEN_COLOR + "/megaverse list &7- Lists you all existing worlds.\n" + divider + "\n" + Utils.GREEN_COLOR + "/megaverse import <world_name> &7- Imports a new downloaded world inside your server root folder.\n" + Utils.GREEN_COLOR + "/megaverse create <world name> &7- Allows you to create a new world.\n" + Utils.GREEN_COLOR + "/megaverse unload <world> &7- Unloads an active world from the server.\n" + Utils.GREEN_COLOR + "/megaverse delete <world_name> &7- Deletes an unloaded world from the server."));
            s.sendMessage(divider);
            return true;
        }
        if (args[0].equalsIgnoreCase("version")) {
            if (MainCommand.noPermission(s, "megaverse.command.version")) {
                return true;
            }
            MainCommand.sendRunningMessages(s);
            return true;
        }
        if (args[0].equalsIgnoreCase("flag")) {
            if (MainCommand.noPermission(s, "megaverse.command.flag")) {
                return true;
            }
            if (args.length <= 2) {
                Utils.incorrectUsage(s, "/megaverse flag <set/remove/info> <world> <flag> [value]");
                return true;
            }
            VerseWorld verseWorld = VerseWorldManager.getVerseWorldByName(args[2]);
            if (verseWorld == null) {
                Utils.formalPlayerWarning(s, "No world found with the name " + args[2]);
                return true;
            }
            String action = args[1].toLowerCase();
            if (action.equals("info")) {
                if (args.length == 3) {
                    s.sendMessage(divider);
                    verseWorld.getFlagsAndValues().forEach((key, value) -> MainCommand.sendClipboardWorldInfo(s, key, String.valueOf(value)));
                    s.sendMessage(divider);
                    return true;
                }
                Flag<?> flag = FlagManager.get(args[3]);
                if (flag == null) {
                    Utils.formalPlayerWarning(s, "No flag found with the id " + Utils.GREEN_COLOR + args[3]);
                    return true;
                }
                Object value2 = verseWorld.getFlagValue(flag);
                if (value2 != null) {
                    Utils.normalMessage(s, "The current value of the flag " + Utils.GREEN_COLOR + flag.getId() + " &ffor this world is " + Utils.GREEN_COLOR + value2);
                } else {
                    Utils.normalMessage(s, "This flag has not been added to this world yet.");
                }
                return true;
            }
            if (args.length >= 4) {
                Flag<?> flag = FlagManager.get(args[3]);
                if (flag == null) {
                    Utils.formalPlayerWarning(s, "No flag found with the id " + Utils.GREEN_COLOR + args[3]);
                    return true;
                }
                if (action.equals("set")) {
                    Object parsedValue;
                    if (args.length == 4) {
                        Utils.incorrectUsage(s, "/megaverse flag set <world> <flag> <value>");
                        return true;
                    }
                    String rawValue = String.join((CharSequence)" ", Arrays.copyOfRange(args, 4, args.length));
                    try {
                        parsedValue = flag.getValueType().parse(rawValue);
                    }
                    catch (Exception e) {
                        Utils.formalPlayerWarning(s, "Invalid value for flag type " + (Object)((Object)flag.getValueType()) + ": " + rawValue);
                        return true;
                    }
                    this.setFlagUnsafe(verseWorld, flag, parsedValue);
                    Utils.normalMessage(s, "Value for flag " + Utils.GREEN_COLOR + flag.getId() + " &fupdated to " + Utils.GREEN_COLOR + parsedValue);
                }
                if (action.equals("remove")) {
                    this.setFlagUnsafe(verseWorld, flag, flag.getDefaultValue());
                    Utils.normalMessage(s, "You removed the flag " + Utils.GREEN_COLOR + flag.getId() + " &ffrom this world.");
                }
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("who")) {
            if (MainCommand.noPermission(s, "megaverse.command.who")) {
                return true;
            }
            w = null;
            if (s instanceof Player) {
                Player p = (Player)s;
                w = p.getWorld();
            } else if (args.length == 1) {
                Utils.incorrectUsage(s, "/megaverse who [world name]");
                return true;
            }
            if (args.length >= 2 && (w = Bukkit.getWorld((String)args[1])) == null) {
                Utils.formalPlayerWarning(s, "No world found with the name " + args[1]);
                return true;
            }
            World world = w;
            List playerList = Bukkit.getOnlinePlayers().stream().filter(a -> a.getWorld().equals(world)).collect(Collectors.toList());
            String playerListMessage = playerList.stream().map(Player::getDisplayName).collect(Collectors.joining(", "));
            Utils.normalMessage(s, "Players currently in the world " + w.getName() + ": " + playerListMessage);
            return true;
        }
        if (args[0].equalsIgnoreCase("import")) {
            if (MainCommand.noPermission(s, "megaverse.command.import")) {
                return true;
            }
            if (args.length == 1) {
                Utils.incorrectUsage(s, "/megaverse import <world_name>");
                return true;
            }
            worldName = args[1];
            if (Bukkit.getWorld((String)worldName) != null) {
                Utils.formalPlayerWarning(s, "A world with this name already exists and is loaded on the server.");
                return true;
            }
            File worldFolder = new File(Bukkit.getWorldContainer(), worldName);
            if (!worldFolder.exists() || !worldFolder.isDirectory()) {
                Utils.formalPlayerWarning(s, "There is no valid world folder with the name " + worldName + ", checking inside this folder: " + Bukkit.getWorldContainer().getAbsolutePath());
                return true;
            }
            if (s instanceof Player) {
                Player p = (Player)s;
                WorldImportGUI.openMenu(p, worldFolder);
                return true;
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("list")) {
            if (MainCommand.noPermission(s, "megaverse.command.list")) {
                return true;
            }
            int size = Bukkit.getWorlds().size();
            s.sendMessage(divider);
            s.sendMessage(Utils.c(Utils.getPrefix() + "There is " + Utils.GREEN_COLOR + size + " &fworlds loaded."));
            s.sendMessage(divider);
            for (World w2 : Bukkit.getWorlds()) {
                MainCommand.sendWorldActionsComponent(s, w2);
            }
            s.sendMessage(divider);
            return true;
        }
        if (args[0].equalsIgnoreCase("create")) {
            if (MainCommand.noPermission(s, "megaverse.command.create")) {
                return true;
            }
            if (args.length == 1) {
                Utils.incorrectUsage(s, "/megaverse create <world_name>");
                return true;
            }
            worldName = args[1];
            if (Bukkit.getWorld((String)worldName) != null) {
                Utils.formalPlayerWarning(s, "A world with this name already exists and is loaded on the server.");
                return true;
            }
            if (s instanceof Player) {
                Player p = (Player)s;
                WorldCreationGUI.openMenu(p, worldName);
                return true;
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("info")) {
            if (MainCommand.noPermission(s, "megaverse.command.info")) {
                return true;
            }
            w = null;
            if (s instanceof Player) {
                Player p = (Player)s;
                w = p.getWorld();
            } else if (args.length == 1) {
                Utils.incorrectUsage(s, "/megaverse info [world name]");
                return true;
            }
            if (args.length >= 2 && (w = Bukkit.getWorld((String)args[1])) == null) {
                Utils.formalPlayerWarning(s, "No world found with the name " + args[1]);
                return true;
            }
            VerseWorld verseWorld = VerseWorldManager.getVerseWorldByWorld(w);
            String isVerseWorld = verseWorld != null ? "Yes" : "\u00a7cNo";
            String isHardcore = w.isHardcore() ? "Yes" : "\u00a7cNo";
            s.sendMessage(divider);
            MainCommand.sendClipboardWorldInfo(s, "World Name", w.getName());
            MainCommand.sendClipboardWorldInfo(s, "World Type", w.getWorldType().toString());
            MainCommand.sendClipboardWorldInfo(s, "World UID", w.getUID().toString());
            MainCommand.sendClipboardWorldInfo(s, "World Environment", w.getEnvironment().toString());
            MainCommand.sendClipboardWorldInfo(s, "World Seed", String.valueOf(w.getSeed()));
            s.sendMessage(divider);
            MainCommand.sendClipboardWorldInfo(s, "Difficulty", w.getDifficulty().name());
            MainCommand.sendClipboardWorldInfo(s, "Hardcore Mode", isHardcore);
            MainCommand.sendClipboardWorldInfo(s, "Simulation Distance", String.valueOf(w.getSimulationDistance()));
            MainCommand.sendClipboardWorldInfo(s, "View Distance", String.valueOf(w.getViewDistance()));
            s.sendMessage(divider);
            MainCommand.sendClipboardWorldInfo(s, "Registered on MegaVerse?", isVerseWorld);
            if (verseWorld != null) {
                MainCommand.sendClipboardWorldInfo(s, "World Generator", verseWorld.getGenerator());
            }
            s.sendMessage(divider);
            return true;
        }
        if (args[0].equalsIgnoreCase("unload")) {
            if (MainCommand.noPermission(s, "megaverse.command.unload")) {
                return true;
            }
            if (args.length == 1) {
                Utils.incorrectUsage(s, "/megaverse unload <world_name>");
                return true;
            }
            w = Bukkit.getWorld((String)args[1]);
            if (w == null) {
                Utils.formalPlayerWarning(s, "This world does not exist or is not loaded on the server.");
                return true;
            }
            Utils.normalMessage(s, "Saving chunks and unloading this world, please wait...");
            if (VerseWorldManager.unloadWorld(w)) {
                Utils.normalMessage(s, "World successfully unloaded from the server!");
            } else {
                Utils.formalPlayerWarning(s, "An unknown error occurred when trying to unload this world.");
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("delete")) {
            if (MainCommand.noPermission(s, "megaverse.command.delete")) {
                return true;
            }
            if (args.length == 1) {
                Utils.incorrectUsage(s, "/megaverse delete <world_name>");
                return true;
            }
            worldName = args[1];
            World w3 = Bukkit.getWorld((String)worldName);
            if (w3 != null) {
                Utils.formalPlayerWarning(s, "You need to unload this world first before trying to delete it. You can unload by using /megaverse unload " + worldName);
                return true;
            }
            if (!confirmDelete.contains(s.getName())) {
                Utils.formalPlayerWarning(s, "Please understand that deleting a world is not recoverable; confirm the action by running the command again.");
                confirmDelete.add(s.getName());
                return true;
            }
            if (VerseWorldManager.deleteWorld(worldName)) {
                Utils.normalMessage(s, "World " + worldName + " successfully deleted from the server!");
            } else {
                Utils.formalPlayerWarning(s, "An unknown error occurred when trying to delete this world.");
            }
            confirmDelete.remove(s.getName());
            return true;
        }
        if (args[0].equalsIgnoreCase("tp")) {
            if (MainCommand.noPermission(s, "megaverse.command.tp")) {
                return true;
            }
            if (args.length == 1) {
                Utils.incorrectUsage(s, "/megaverse tp <world name> [player]");
                return true;
            }
            w = Bukkit.getWorld((String)args[1]);
            if (w == null) {
                Utils.formalPlayerWarning(s, "This world does not exists or is not loaded.");
                return true;
            }
            Location location = VerseWorldManager.getSafeSpawnLocation(w);
            if (s instanceof Player) {
                Player p = (Player)s;
                p.teleport(location);
                return true;
            }
            if (args.length == 2) {
                s.sendMessage(Utils.GREEN_COLOR + "/megaverse tp <world name> [player]");
                return true;
            }
            Player player = Bukkit.getPlayer((String)args[2]);
            if (player == null) {
                Utils.formalPlayerWarning(s, "This player does not exist or is not online.");
                return true;
            }
            player.teleport(location);
            return true;
        }
        return false;
    }

    private <T> void setFlagUnsafe(VerseWorld verseWorld, Flag<?> rawFlag, Object rawValue) {
        Flag<?> flag = rawFlag;
        Object value = rawValue;
        verseWorld.setFlagValue(flag, value);
    }

    private static boolean noPermission(CommandSender s, String permission) {
        boolean perm = s.hasPermission(permission);
        if (!perm) {
            Utils.formalPlayerWarning(s, "You need this permission: " + permission + " in order to use this command.");
        }
        return !perm;
    }
}

