/*
 * Decompiled with CFR 0.152.
 */
package me.drawn.management;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import me.drawn.management.VerseWorldManager;
import me.paulferlitz.IO.NBTReader;
import me.paulferlitz.NBTTags.Tag_Byte;
import me.paulferlitz.NBTTags.Tag_Compound;
import me.paulferlitz.NBTTags.Tag_Long;
import me.paulferlitz.NBTTags.Tag_String;
import org.bukkit.Bukkit;
import org.bukkit.Difficulty;
import org.jetbrains.annotations.NotNull;

public class VerseImportManager {
    public static List<String> getValidImportableWorlds() {
        return Arrays.stream(Objects.requireNonNull(Bukkit.getWorldContainer().listFiles())).filter(File::isDirectory).filter(file -> {
            File levelDat = new File((File)file, "level.dat");
            return levelDat.exists() && !VerseWorldManager.getLoadedWorldsNames().contains(file.getName());
        }).map(File::getName).collect(Collectors.toList());
    }

    public static class ImportOptions {
        private final File worldDirectory;
        private final File levelDat;
        private final String version;
        private final boolean hardcoreMode;
        private final boolean raining;
        private final Date lastPlayed;
        private final Difficulty difficulty;
        private final String worldType;
        private final boolean wasModded;
        private final boolean wasSet;

        public ImportOptions(@NotNull File worldDirectory) throws IOException {
            this.worldDirectory = worldDirectory;
            this.levelDat = new File(worldDirectory, "level.dat");
            if (this.levelDat.exists()) {
                NBTReader nbtReader = new NBTReader(this.levelDat);
                Tag_Compound root = nbtReader.read();
                boolean wasModded = (Byte)((Tag_Byte)root.getTagByName("WasModded")).getData() == 1;
                boolean hardcore = (Byte)((Tag_Byte)root.getTagByName("hardcore")).getData() == 1;
                boolean raining = (Byte)((Tag_Byte)root.getTagByName("raining")).getData() == 1 || (Byte)((Tag_Byte)root.getTagByName("thundering")).getData() == 1;
                Tag_String version = (Tag_String)((Tag_Compound)root.getTagByName("Version")).getTagByName("Name");
                String worldType = "Unknown";
                try {
                    Tag_Compound dimensions = (Tag_Compound)((Tag_Compound)root.getTagByName("WorldGenSettings")).getTagByName("dimensions");
                    Tag_Compound overWorldGenerator = (Tag_Compound)((Tag_Compound)dimensions.getTagByName("minecraft:overworld")).getTagByName("generator");
                    worldType = (String)((Tag_String)overWorldGenerator.getTagByName("type")).getData();
                }
                catch (Exception dimensions) {
                    // empty catch block
                }
                Difficulty difficulty = Difficulty.getByValue((int)((Byte)((Tag_Byte)root.getTagByName("Difficulty")).getData()).byteValue());
                long lastPlayed = (Long)((Tag_Long)root.getTagByName("LastPlayed")).getData();
                this.version = (String)version.getData();
                this.hardcoreMode = hardcore;
                this.raining = raining;
                this.wasModded = wasModded;
                this.lastPlayed = new Date(lastPlayed);
                this.wasSet = true;
                this.difficulty = difficulty;
                this.worldType = worldType;
                nbtReader.close();
            } else {
                this.version = null;
                this.hardcoreMode = false;
                this.raining = false;
                this.lastPlayed = null;
                this.wasSet = false;
                this.wasModded = false;
                this.difficulty = null;
                this.worldType = null;
            }
        }

        public boolean isHardcoreMode() {
            return this.hardcoreMode;
        }

        public Difficulty getDifficulty() {
            return this.difficulty;
        }

        public boolean wasModded() {
            return this.wasModded;
        }

        public String getVersion() {
            return this.version;
        }

        public String getWorldType() {
            return this.worldType;
        }

        public boolean isRaining() {
            return this.raining;
        }

        public Date getLastPlayed() {
            return this.lastPlayed;
        }

        public boolean wasSet() {
            return this.wasSet;
        }

        public File getLevelDat() {
            return this.levelDat;
        }

        public File getWorldDirectory() {
            return this.worldDirectory;
        }
    }
}

