/*
 * Decompiled with CFR 0.152.
 */
package me.drawn.management.flags;

import me.drawn.management.VerseWorldManager;
import me.drawn.management.flags.FlagManager;
import me.drawn.utils.Utils;
import org.bukkit.GameMode;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.bukkit.event.world.PortalCreateEvent;

public class FlagEvents
implements Listener {
    @EventHandler
    public void onDamage(EntityDamageByEntityEvent e) {
        if (e.getDamager().getType() == EntityType.PLAYER && e.getEntity().getType() == EntityType.PLAYER) {
            VerseWorldManager.getVerseWorld(e.getEntity().getWorld()).ifPresent(verseWorld -> {
                Player attacker = (Player)e.getDamager();
                if (!verseWorld.getFlagValue(FlagManager.PVP).booleanValue() && !attacker.hasPermission("megaverse.bypass.flag.pvp")) {
                    e.setCancelled(true);
                }
            });
        }
    }

    @EventHandler
    public void onPortal(PortalCreateEvent e) {
        VerseWorldManager.getVerseWorld(e.getWorld()).ifPresent(verseWorld -> {
            if (!verseWorld.getFlagValue(FlagManager.PORTAL_FORMATION).booleanValue()) {
                e.setCancelled(true);
            }
        });
    }

    @EventHandler
    public void onWeather(WeatherChangeEvent e) {
        VerseWorldManager.getVerseWorld(e.getWorld()).ifPresent(verseWorld -> {
            if (!verseWorld.getFlagValue(FlagManager.ALLOW_WEATHER_CHANGES).booleanValue()) {
                e.setCancelled(true);
            }
        });
    }

    @EventHandler
    public void onWorld(PlayerChangedWorldEvent e) {
        Player player = e.getPlayer();
        World world = player.getWorld();
        VerseWorldManager.getVerseWorld(world).ifPresent(verseWorld -> {
            String messageOnEnter;
            String titleOnEnter;
            GameMode gameMode;
            if (verseWorld.isFlagSet(FlagManager.GAMEMODE) && (gameMode = GameMode.getByValue((int)verseWorld.getFlagValue(FlagManager.GAMEMODE))) != null) {
                player.setGameMode(gameMode);
            }
            if (verseWorld.isFlagSet(FlagManager.TITLE_ON_ENTER) && (titleOnEnter = verseWorld.getFlagValue(FlagManager.TITLE_ON_ENTER)) != null && !titleOnEnter.isEmpty()) {
                player.sendTitle(Utils.c(titleOnEnter), "", 20, 20, 20);
            }
            if (verseWorld.isFlagSet(FlagManager.MESSAGE_ON_ENTER) && (messageOnEnter = verseWorld.getFlagValue(FlagManager.MESSAGE_ON_ENTER)) != null && !messageOnEnter.isEmpty()) {
                player.sendMessage(Utils.c(messageOnEnter));
            }
        });
    }
}

