/*
 * Decompiled with CFR 0.152.
 */
package me.drawn.management.generators;

import java.util.Random;
import me.drawn.MegaVerse;
import me.drawn.management.entities.VerseGenerator;
import me.drawn.utils.noises.FastNoiseLite;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class AetherGenerator
extends VerseGenerator {
    public AetherGenerator() {
        super((Plugin)MegaVerse.getInstance(), "aether_generator", "Aether Generator", new BukkitAetherGenerator(6469L), Material.ELYTRA);
    }

    public static class BukkitAetherGenerator
    extends ChunkGenerator {
        private final FastNoiseLite placementNoise;
        private final FastNoiseLite islandSpecificParamNoise;
        private final FastNoiseLite shapeNoise;
        private final long worldSeed;
        private static final float PLACEMENT_FREQUENCY = 0.007f;
        private static final float ISLAND_PARAM_FREQUENCY = 0.1f;
        private static final float SHAPE_NOISE_FREQUENCY = 0.035f;
        private static final float ISLAND_PLACEMENT_THRESHOLD = 0.5f;
        private static final float ISLAND_MAX_RADIUS_BASE = 30.0f;
        private static final float ISLAND_MAX_RADIUS_VARIATION = 45.0f;
        private static final float ISLAND_HEIGHT_BASE = 20.0f;
        private static final float ISLAND_HEIGHT_VARIATION = 60.0f;
        private static final int ISLAND_MEAN_TOP_Y_LEVEL = 60;
        private static final int ISLAND_TOP_Y_LEVEL_VARIATION = 30;
        private static final int DIRT_LAYER_THICKNESS = 4;
        private static final int ISLAND_GRID_CELL_SIZE = 128;
        private static final int ISLAND_SEARCH_GRID_RADIUS = 1;

        public BukkitAetherGenerator(long seed) {
            this.worldSeed = seed;
            this.placementNoise = new FastNoiseLite((int)seed);
            this.placementNoise.SetNoiseType(FastNoiseLite.NoiseType.OpenSimplex2);
            this.placementNoise.SetFrequency(0.007f);
            this.islandSpecificParamNoise = new FastNoiseLite((int)(seed + 1L));
            this.islandSpecificParamNoise.SetNoiseType(FastNoiseLite.NoiseType.OpenSimplex2);
            this.islandSpecificParamNoise.SetFrequency(0.1f);
            this.shapeNoise = new FastNoiseLite((int)(seed + 2L));
            this.shapeNoise.SetNoiseType(FastNoiseLite.NoiseType.OpenSimplex2S);
            this.shapeNoise.SetFrequency(0.035f);
        }

        public ChunkGenerator.ChunkData generateChunkData(@NotNull World world, @NotNull Random random, int chunkX, int chunkZ, @NotNull ChunkGenerator.BiomeGrid biome) {
            ChunkGenerator.ChunkData chunkData = this.createChunkData(world);
            int minY = world.getMinHeight();
            int maxY = world.getMaxHeight();
            int centerChunkOriginX = chunkX * 16 + 8;
            int centerChunkOriginZ = chunkZ * 16 + 8;
            int currentChunkGridX = Math.floorDiv(centerChunkOriginX, 128);
            int currentChunkGridZ = Math.floorDiv(centerChunkOriginZ, 128);
            for (int gridOffsetX = -1; gridOffsetX <= 1; ++gridOffsetX) {
                for (int gridOffsetZ = -1; gridOffsetZ <= 1; ++gridOffsetZ) {
                    int islandGridX = currentChunkGridX + gridOffsetX;
                    int islandGridZ = currentChunkGridZ + gridOffsetZ;
                    long islandCellSeed = this.worldSeed ^ (long)islandGridX * 73856093L ^ (long)islandGridZ * 19349663L;
                    this.islandSpecificParamNoise.SetSeed((int)islandCellSeed);
                    float placementValue = this.placementNoise.GetNoise(islandGridX * 128, islandGridZ * 128);
                    if (!(placementValue > 0.5f)) continue;
                    float offsetXRatio = this.islandSpecificParamNoise.GetNoise(10.0f, 10.0f) * 0.5f + 0.5f;
                    float offsetZRatio = this.islandSpecificParamNoise.GetNoise(20.0f, 20.0f) * 0.5f + 0.5f;
                    float islandCenterX = ((float)islandGridX + offsetXRatio) * 128.0f;
                    float islandCenterZ = ((float)islandGridZ + offsetZRatio) * 128.0f;
                    float heightNoiseVal = this.islandSpecificParamNoise.GetNoise(30.0f, 30.0f) * 0.5f + 0.5f;
                    float radiusNoiseVal = this.islandSpecificParamNoise.GetNoise(40.0f, 40.0f) * 0.5f + 0.5f;
                    float yOffsetNoiseVal = this.islandSpecificParamNoise.GetNoise(50.0f, 50.0f);
                    float islandHeight = 20.0f + heightNoiseVal * 60.0f;
                    float islandMaxRadius = 30.0f + radiusNoiseVal * 45.0f;
                    float islandTopSurfaceY = 60.0f + yOffsetNoiseVal * 30.0f;
                    float islandBottomTipY = islandTopSurfaceY - islandHeight;
                    if (islandHeight <= 0.0f || islandMaxRadius <= 0.0f) continue;
                    for (int localX = 0; localX < 16; ++localX) {
                        for (int localZ = 0; localZ < 16; ++localZ) {
                            int worldX = chunkX * 16 + localX;
                            int worldZ = chunkZ * 16 + localZ;
                            double distSqToIslandAxis = ((float)worldX - islandCenterX) * ((float)worldX - islandCenterX) + ((float)worldZ - islandCenterZ) * ((float)worldZ - islandCenterZ);
                            for (int worldY = minY; worldY < maxY; ++worldY) {
                                double currentTheoreticalRadius;
                                if (!((float)worldY >= islandBottomTipY) || !((float)worldY < islandTopSurfaceY)) continue;
                                double heightRatioFromTip = ((float)worldY - islandBottomTipY) / islandHeight;
                                if (heightRatioFromTip < 0.0) {
                                    heightRatioFromTip = 0.0;
                                }
                                if (heightRatioFromTip > 1.0) {
                                    heightRatioFromTip = 1.0;
                                }
                                if ((currentTheoreticalRadius = (double)islandMaxRadius * Math.pow(heightRatioFromTip, 0.65)) <= 0.0) continue;
                                float surfacePerturbationAmount = 3.5f;
                                float surfaceNoiseVal = this.shapeNoise.GetNoise(worldX, worldY, worldZ);
                                double perturbedRadius = currentTheoreticalRadius + (double)(surfaceNoiseVal * surfacePerturbationAmount);
                                if (perturbedRadius <= 0.0 || !(distSqToIslandAxis < perturbedRadius * perturbedRadius)) continue;
                                float actualTopSurfaceForMaterial = islandTopSurfaceY + this.shapeNoise.GetNoise((float)worldX * 0.25f, (float)worldZ * 0.25f) * 2.5f;
                                Material blockMaterial = (float)worldY >= actualTopSurfaceForMaterial - 1.0f && (float)worldY < islandTopSurfaceY + 5.0f ? Material.GRASS_BLOCK : ((float)worldY >= actualTopSurfaceForMaterial - 4.0f && (float)worldY < islandTopSurfaceY + 5.0f ? (random.nextInt(4) == 3 ? Material.COARSE_DIRT : Material.DIRT) : Material.STONE);
                                if (worldY < chunkData.getMinHeight() || worldY >= chunkData.getMaxHeight()) continue;
                                chunkData.setBlock(localX, worldY, localZ, blockMaterial);
                            }
                        }
                    }
                }
            }
            int biomeMinY_cell = Math.floorDiv(minY, 4);
            int biomeMaxY_cell = Math.floorDiv(maxY, 4);
            for (int bioX = 0; bioX < 4; ++bioX) {
                for (int bioZ = 0; bioZ < 4; ++bioZ) {
                    for (int bioY = biomeMinY_cell; bioY < biomeMaxY_cell; ++bioY) {
                        if (chunkData.getMinHeight() > bioY * 4 || bioY * 4 >= chunkData.getMaxHeight()) continue;
                        biome.setBiome(bioX, bioY - Math.floorDiv(chunkData.getMinHeight(), 4), bioZ, Biome.THE_VOID);
                    }
                }
            }
            return chunkData;
        }

        public boolean shouldGenerateStructures() {
            return true;
        }

        public boolean shouldGenerateDecorations() {
            return true;
        }

        public boolean shouldGenerateMobs() {
            return true;
        }
    }
}

