/*
 * Decompiled with CFR 0.152.
 */
package me.drawn.management.generators;

import java.util.Random;
import me.drawn.MegaVerse;
import me.drawn.management.entities.VerseGenerator;
import me.drawn.utils.noises.FastNoiseLite;
import org.bukkit.Material;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.plugin.Plugin;

public class BigIslandsGenerator
extends VerseGenerator {
    public BigIslandsGenerator() {
        super((Plugin)MegaVerse.getInstance(), "big_islands_generator", "Big Islands Generator", new BukkitIslandGenerator(0.0035f), Material.GRASS_BLOCK);
    }

    public static final class BukkitIslandGenerator
    extends ChunkGenerator {
        private final FastNoiseLite noise = new FastNoiseLite();
        private final int seaLevel = 63;
        private final int oceanFloorLevel = 30;
        private final double islandThreshold = 0.25;
        private final int islandMaxHeightAboveSea = 25;
        private final int deepslateStartY = 0;

        public BukkitIslandGenerator(float frequency) {
            this.noise.SetNoiseType(FastNoiseLite.NoiseType.Perlin);
            this.noise.SetFrequency(frequency);
            this.noise.SetFractalType(FastNoiseLite.FractalType.FBm);
            this.noise.SetFractalOctaves(3);
            this.noise.SetFractalLacunarity(2.0f);
            this.noise.SetFractalGain(0.45f);
        }

        public void generateNoise(WorldInfo worldInfo, Random random, int chunkX, int chunkZ, ChunkGenerator.ChunkData chunkData) {
            int worldMinY = worldInfo.getMinHeight();
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    int y;
                    int terrainHeight;
                    int worldX = chunkX * 16 + x;
                    int worldZ = chunkZ * 16 + z;
                    float noiseValue = this.noise.GetNoise(worldX, worldZ);
                    if ((double)noiseValue < 0.25) {
                        float oceanDepthFactor = (noiseValue + 1.0f) / 1.25f;
                        terrainHeight = 30 + (int)(oceanDepthFactor * 32.0f);
                        terrainHeight = Math.max(30, terrainHeight);
                        terrainHeight = Math.max(terrainHeight, worldMinY);
                    } else {
                        float islandHeightFactor = (noiseValue - 0.25f) / 0.75f;
                        int baseIslandHeight = 61;
                        terrainHeight = baseIslandHeight + (int)(islandHeightFactor * (float)(25 + (63 - baseIslandHeight)));
                        terrainHeight = Math.min(terrainHeight, 88);
                    }
                    for (y = worldMinY; y <= terrainHeight; ++y) {
                        Material blockMaterial;
                        Material material = blockMaterial = y < 0 ? Material.DEEPSLATE : Material.STONE;
                        if (chunkData.getType(x, y, z) == Material.BEDROCK) continue;
                        chunkData.setBlock(x, y, z, blockMaterial);
                    }
                    if (terrainHeight >= 63) continue;
                    for (y = terrainHeight + 1; y < 63; ++y) {
                        if (chunkData.getType(x, y, z) == Material.BEDROCK) continue;
                        chunkData.setBlock(x, y, z, Material.WATER);
                    }
                }
            }
        }

        public void generateSurface(WorldInfo worldInfo, Random random, int chunkX, int chunkZ, ChunkGenerator.ChunkData chunkData) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    Material below;
                    int i;
                    Material surfaceBlock;
                    Material baseMaterial;
                    Material currentMaterial;
                    int startY;
                    int highestY = -1;
                    for (int y = startY = Math.min(chunkData.getMaxHeight() - 1, 93); y >= worldInfo.getMinHeight(); --y) {
                        Material blockType = chunkData.getType(x, y, z);
                        if (blockType == Material.AIR || blockType == Material.WATER) continue;
                        highestY = y;
                        break;
                    }
                    if (highestY == -1 || (currentMaterial = chunkData.getType(x, highestY, z)) == Material.BEDROCK) continue;
                    Material material = baseMaterial = highestY < 0 ? Material.DEEPSLATE : Material.STONE;
                    if (highestY < 62) {
                        surfaceBlock = Material.SAND;
                        chunkData.setBlock(x, highestY, z, surfaceBlock);
                        if (highestY - 1 < worldInfo.getMinHeight() || chunkData.getType(x, highestY - 1, z) == baseMaterial) continue;
                        if (chunkData.getType(x, highestY - 1, z) == Material.STONE && baseMaterial == Material.DEEPSLATE) {
                            chunkData.setBlock(x, highestY - 1, z, baseMaterial);
                            continue;
                        }
                        if (chunkData.getType(x, highestY - 1, z) != Material.DEEPSLATE || baseMaterial != Material.STONE) continue;
                        chunkData.setBlock(x, highestY - 1, z, baseMaterial);
                        continue;
                    }
                    if (highestY < 65) {
                        surfaceBlock = Material.SAND;
                        chunkData.setBlock(x, highestY, z, surfaceBlock);
                        for (i = 1; i <= 3 && highestY - i >= worldInfo.getMinHeight() && ((below = chunkData.getType(x, highestY - i, z)) == Material.STONE || below == Material.DEEPSLATE); ++i) {
                            chunkData.setBlock(x, highestY - i, z, random.nextInt(3) == 0 ? Material.SANDSTONE : Material.SAND);
                        }
                        continue;
                    }
                    surfaceBlock = Material.GRASS_BLOCK;
                    Material belowSurfaceBlock = Material.DIRT;
                    chunkData.setBlock(x, highestY, z, surfaceBlock);
                    for (i = 1; i <= 3 && highestY - i >= worldInfo.getMinHeight() && ((below = chunkData.getType(x, highestY - i, z)) == Material.STONE || below == Material.DEEPSLATE); ++i) {
                        chunkData.setBlock(x, highestY - i, z, belowSurfaceBlock);
                    }
                }
            }
        }

        public void generateBedrock(WorldInfo worldInfo, Random random, int chunkX, int chunkZ, ChunkGenerator.ChunkData chunkData) {
            int minY = worldInfo.getMinHeight();
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    if (chunkData.getType(x, minY, z).isAir() || chunkData.getType(x, minY, z) == Material.STONE) {
                        chunkData.setBlock(x, minY, z, Material.BEDROCK);
                    }
                    for (int y = minY + 1; y < minY + 5; ++y) {
                        Material currentMat;
                        if (random.nextInt(5) < y - minY || (currentMat = chunkData.getType(x, y, z)) != Material.STONE && currentMat != Material.DEEPSLATE) continue;
                        chunkData.setBlock(x, y, z, Material.BEDROCK);
                    }
                }
            }
        }

        public boolean shouldGenerateStructures() {
            return true;
        }

        public boolean shouldGenerateDecorations() {
            return true;
        }

        public boolean shouldGenerateMobs() {
            return true;
        }
    }
}

