/*
 * Decompiled with CFR 0.152.
 */
package me.drawn.management.generators;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import me.drawn.MegaVerse;
import me.drawn.management.entities.VerseGenerator;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class VoidGenerator
extends VerseGenerator {
    public VoidGenerator() {
        super((Plugin)MegaVerse.getInstance(), "void_generator", "Void Generator", new BukkitVoidGenerator(), Material.STRUCTURE_VOID);
    }

    public static final class BukkitVoidGenerator
    extends ChunkGenerator {
        @NotNull
        public ChunkGenerator.ChunkData generateChunkData(@NotNull World world, @NotNull Random random, int x, int z, @NotNull ChunkGenerator.BiomeGrid biome) {
            ChunkGenerator.ChunkData data = this.createChunkData(world);
            if (x == 0 && z == 0) {
                data.setBlock(0, 64, 0, Material.BEDROCK);
            }
            return data;
        }

        public BiomeProvider getDefaultBiomeProvider(WorldInfo worldInfo) {
            return new VoidBiomeProvider();
        }

        public static class VoidBiomeProvider
        extends BiomeProvider {
            private static final List<Biome> biomes = Collections.singletonList(Biome.PLAINS);

            public Biome getBiome(WorldInfo worldInfo, int x, int y, int z) {
                return Biome.PLAINS;
            }

            public List<Biome> getBiomes(WorldInfo worldInfo) {
                return biomes;
            }
        }
    }
}

