/*
 * Decompiled with CFR 0.152.
 */
package me.paulferlitz.IO;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import me.paulferlitz.IO.NBTFileHandler;
import me.paulferlitz.NBTTags.NBTTags;
import me.paulferlitz.NBTTags.Tag;
import me.paulferlitz.NBTTags.Tag_Byte;
import me.paulferlitz.NBTTags.Tag_Byte_Array;
import me.paulferlitz.NBTTags.Tag_Compound;
import me.paulferlitz.NBTTags.Tag_Double;
import me.paulferlitz.NBTTags.Tag_End;
import me.paulferlitz.NBTTags.Tag_Float;
import me.paulferlitz.NBTTags.Tag_Int;
import me.paulferlitz.NBTTags.Tag_Int_Array;
import me.paulferlitz.NBTTags.Tag_List;
import me.paulferlitz.NBTTags.Tag_Long;
import me.paulferlitz.NBTTags.Tag_Long_Array;
import me.paulferlitz.NBTTags.Tag_Short;
import me.paulferlitz.NBTTags.Tag_String;

public class NBTReader {
    private final DataInputStream stream;

    public NBTReader(File nbtFile) {
        try {
            this.stream = NBTFileHandler.loadNBTToReader(nbtFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public NBTReader(DataInputStream dis) {
        this.stream = dis;
    }

    public void close() throws IOException {
        this.stream.close();
    }

    public static DataInputStream byteArrayToDataInputStream(byte[] chunkData) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(chunkData);
        return new DataInputStream(byteArrayInputStream);
    }

    public Tag_Compound read() throws IOException {
        Tag_Compound tag;
        try {
            tag = (Tag_Compound)this.readNBTTag(0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.close();
        }
        return tag;
    }

    private Tag readNBTTag(int depth) throws IOException {
        byte type = this.stream.readByte();
        String name = "";
        if (type != NBTTags.Tag_End.getId()) {
            int nameLength = this.stream.readUnsignedShort();
            byte[] byteBuffer = new byte[nameLength];
            this.stream.readFully(byteBuffer);
            name = new String(byteBuffer, StandardCharsets.UTF_8);
        }
        return this.readNBTPayload(type, name, depth);
    }

    private Tag readNBTPayload(int type, String name, int depth) throws IOException {
        switch (NBTTags.getById(type)) {
            case Tag_End: {
                if (depth == 0) {
                    throw new IOException("Tag_End found before the first Tag_Compound was started. Invalid!");
                }
                return new Tag_End();
            }
            case Tag_Byte: {
                return new Tag_Byte(name, this.stream.readByte());
            }
            case Tag_Short: {
                return new Tag_Short(name, this.stream.readShort());
            }
            case Tag_Int: {
                return new Tag_Int(name, this.stream.readInt());
            }
            case Tag_Long: {
                return new Tag_Long(name, this.stream.readLong());
            }
            case Tag_Float: {
                return new Tag_Float(name, this.stream.readFloat());
            }
            case Tag_Double: {
                return new Tag_Double(name, this.stream.readDouble());
            }
            case Tag_Byte_Array: {
                int arrayLength = this.stream.readInt();
                byte[] byteBuffer = new byte[arrayLength];
                this.stream.readFully(byteBuffer);
                return new Tag_Byte_Array(name, byteBuffer);
            }
            case Tag_String: {
                int arrayLength = this.stream.readUnsignedShort();
                byte[] byteBuffer = new byte[arrayLength];
                this.stream.readFully(byteBuffer);
                return new Tag_String(name, new String(byteBuffer, StandardCharsets.UTF_8));
            }
            case Tag_List: {
                ArrayList tagList = new ArrayList();
                byte listType = this.stream.readByte();
                int arrayLength = this.stream.readInt();
                for (int i = 0; i < arrayLength; ++i) {
                    tagList.add(this.readNBTPayload(listType, "", depth + 1));
                }
                return new Tag_List(name, listType, tagList);
            }
            case Tag_Compound: {
                Tag tag;
                ArrayList tagList = new ArrayList();
                while ((tag = this.readNBTTag(depth + 1)).getId() != NBTTags.Tag_End.getId()) {
                    tagList.add(tag);
                }
                return new Tag_Compound(name, tagList);
            }
            case Tag_Int_Array: {
                int arrayLength = this.stream.readInt();
                int[] intArray = new int[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    intArray[i] = this.stream.readInt();
                }
                return new Tag_Int_Array(name, intArray);
            }
            case Tag_Long_Array: {
                int arrayLength = this.stream.readInt();
                long[] longArray = new long[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    longArray[i] = this.stream.readLong();
                }
                return new Tag_Long_Array(name, longArray);
            }
        }
        throw new IllegalStateException("Unexpected value: " + type);
    }
}

