/*
 * Decompiled with CFR 0.152.
 */
package me.paulferlitz.NBTTags;

import java.util.Objects;
import java.util.function.Consumer;
import me.paulferlitz.NBTTags.NBTTags;

public abstract class Tag<T> {
    private final int id;
    private String name;
    protected T data;

    public Tag(int id) {
        this(id, "null", null);
    }

    public Tag(int id, String name) {
        this(id, name, null);
    }

    public Tag(int id, String name, T data) {
        if (NBTTags.getById(id) == null) {
            throw new IllegalArgumentException("Invalid ID: " + id);
        }
        this.id = id;
        this.name = name == null || name.isEmpty() ? "null" : name;
        this.data = data;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null || name.isEmpty() ? "null" : name;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        if (this.data.getClass() != data.getClass()) {
            throw new IllegalArgumentException(String.format("Tag type mismatch! Expected %s, got %s", this.data.getClass(), data.getClass()));
        }
        this.data = data;
    }

    public void editTag(Tag<?> newTag) {
        if (this.getId() != newTag.getId()) {
            throw new IllegalArgumentException(String.format("Tag type mismatch! Expected %d, got %d", this.getId(), newTag.getId()));
        }
        this.setName(newTag.getName());
        this.setData(newTag.getData());
    }

    public void applyOperation(Consumer<Tag<T>> operation) {
        operation.accept(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Tag tag = (Tag)obj;
        return this.id == tag.id && Objects.equals(this.name, tag.name) && Objects.equals(this.data, tag.data);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.data);
    }

    public String toString() {
        return NBTTags.getById(this.getId()).getName() + "(\"" + this.getName() + "\"): " + this.getData();
    }
}

