/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.randomvillagenames_common_forge.events;

import com.natamus.collective_common_forge.functions.BlockPosFunctions;
import com.natamus.collective_common_forge.functions.HashMapFunctions;
import com.natamus.collective_common_forge.functions.TileEntityFunctions;
import com.natamus.randomvillagenames_common_forge.util.Util;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;

public class SetVillageSignEvent {
    private static final HashMap<ServerLevel, List<ChunkPos>> processChunks = new HashMap();
    private static final HashMap<ServerLevel, CopyOnWriteArrayList<BlockPos>> existingvillages = new HashMap();
    private static final HashMap<ServerLevel, ArrayList<ChunkPos>> cachedchunks = new HashMap();

    public static void onWorldTick(ServerLevel serverlevel) {
        if (((List)HashMapFunctions.computeIfAbsent(processChunks, (Object)serverlevel, k -> new ArrayList())).size() > 0) {
            ChunkPos chunkpos = processChunks.get(serverlevel).get(0);
            if (!((ArrayList)HashMapFunctions.computeIfAbsent(cachedchunks, (Object)serverlevel, k -> new ArrayList())).contains(chunkpos)) {
                cachedchunks.get(serverlevel).add(chunkpos);
                BlockPos worldpos = chunkpos.m_45615_();
                if (serverlevel.m_8828_(SectionPos.m_123199_((BlockPos)worldpos)) <= 4) {
                    for (BlockPos existingvillage : (CopyOnWriteArrayList)HashMapFunctions.computeIfAbsent(existingvillages, (Object)serverlevel, k -> new CopyOnWriteArrayList())) {
                        if (Math.abs(existingvillage.m_123341_() - worldpos.m_123341_()) > 200 || Math.abs(existingvillage.m_123343_() - worldpos.m_123343_()) > 200) continue;
                        return;
                    }
                    BlockPos villagepos = BlockPosFunctions.getNearbyVillage((ServerLevel)serverlevel, (BlockPos)worldpos);
                    if (villagepos == null) {
                        return;
                    }
                    if (existingvillages.get(serverlevel).contains(villagepos)) {
                        return;
                    }
                    existingvillages.get(serverlevel).add(villagepos);
                    BlockPos twonorth = villagepos.m_7949_().m_122013_(2);
                    if (Util.hasAreasSignNeaby((Level)serverlevel, twonorth, 15)) {
                        return;
                    }
                    BlockPos signpos = BlockPosFunctions.getSurfaceBlockPos((ServerLevel)serverlevel, (int)twonorth.m_123341_(), (int)twonorth.m_123343_());
                    BlockState state = serverlevel.m_8055_(signpos);
                    Block block = state.m_60734_();
                    while (!Util.isOverwritableBlockOrSign(block)) {
                        if ((signpos = signpos.m_7494_().m_7949_()).m_123342_() >= 256) {
                            return;
                        }
                        state = serverlevel.m_8055_(signpos);
                        block = state.m_60734_();
                    }
                    try {
                        Block northblock = serverlevel.m_8055_(signpos.m_122012_()).m_60734_();
                        if (!Util.isOverwritableBlockOrSign(northblock)) {
                            serverlevel.m_46597_(signpos, (BlockState)Blocks.f_50158_.m_49966_().m_61124_((Property)WallSignBlock.f_58064_, (Comparable)Direction.SOUTH));
                        } else {
                            serverlevel.m_46597_(signpos, Blocks.f_50095_.m_49966_());
                        }
                    }
                    catch (ConcurrentModificationException northblock) {
                        // empty catch block
                    }
                    BlockEntity te = serverlevel.m_7702_(signpos);
                    if (!(te instanceof SignBlockEntity)) {
                        return;
                    }
                    SignBlockEntity signentity = (SignBlockEntity)te;
                    signentity.m_276956_(signentity.m_277142_().m_276913_(0, (Component)Component.m_237113_((String)"[Area] 60")), true);
                    TileEntityFunctions.updateTileEntity((Level)serverlevel, (BlockPos)signpos, (BlockEntity)signentity);
                }
            }
            processChunks.get(serverlevel).remove(0);
        }
    }

    public static void onChunkLoad(ServerLevel serverlevel, LevelChunk chunk) {
        if (!serverlevel.m_7654_().m_129910_().m_246337_().m_247749_()) {
            return;
        }
        ChunkPos chunkpos = chunk.m_7697_();
        if (((ArrayList)HashMapFunctions.computeIfAbsent(cachedchunks, (Object)serverlevel, k -> new ArrayList())).contains(chunkpos)) {
            return;
        }
        ((List)HashMapFunctions.computeIfAbsent(processChunks, (Object)serverlevel, k -> new ArrayList())).add(chunkpos);
    }
}

