/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.randomvillagenames_common_neoforge.events;

import com.natamus.collective_common_neoforge.functions.BlockPosFunctions;
import com.natamus.collective_common_neoforge.functions.HashMapFunctions;
import com.natamus.collective_common_neoforge.functions.TileEntityFunctions;
import com.natamus.randomvillagenames_common_neoforge.util.Util;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;

public class SetVillageSignEvent {
    private static final HashMap<ServerLevel, List<ChunkPos>> processChunks = new HashMap();
    private static final HashMap<ServerLevel, CopyOnWriteArrayList<BlockPos>> existingvillages = new HashMap();
    private static final HashMap<ServerLevel, ArrayList<ChunkPos>> cachedchunks = new HashMap();

    public static void onWorldTick(ServerLevel serverlevel) {
        if (((List)HashMapFunctions.computeIfAbsent(processChunks, (Object)serverlevel, k -> new ArrayList())).size() > 0) {
            ChunkPos chunkpos = processChunks.get(serverlevel).get(0);
            if (!((ArrayList)HashMapFunctions.computeIfAbsent(cachedchunks, (Object)serverlevel, k -> new ArrayList())).contains(chunkpos)) {
                cachedchunks.get(serverlevel).add(chunkpos);
                BlockPos worldpos = chunkpos.getWorldPosition();
                if (serverlevel.sectionsToVillage(SectionPos.of((BlockPos)worldpos)) <= 4) {
                    for (BlockPos existingvillage : (CopyOnWriteArrayList)HashMapFunctions.computeIfAbsent(existingvillages, (Object)serverlevel, k -> new CopyOnWriteArrayList())) {
                        if (Math.abs(existingvillage.getX() - worldpos.getX()) > 200 || Math.abs(existingvillage.getZ() - worldpos.getZ()) > 200) continue;
                        return;
                    }
                    BlockPos villagepos = BlockPosFunctions.getNearbyVillage((ServerLevel)serverlevel, (BlockPos)worldpos);
                    if (villagepos == null) {
                        return;
                    }
                    if (existingvillages.get(serverlevel).contains(villagepos)) {
                        return;
                    }
                    existingvillages.get(serverlevel).add(villagepos);
                    BlockPos twonorth = villagepos.immutable().north(2);
                    if (Util.hasAreasSignNeaby((Level)serverlevel, twonorth, 15)) {
                        return;
                    }
                    BlockPos signpos = BlockPosFunctions.getSurfaceBlockPos((ServerLevel)serverlevel, (int)twonorth.getX(), (int)twonorth.getZ());
                    BlockState state = serverlevel.getBlockState(signpos);
                    Block block = state.getBlock();
                    while (!Util.isOverwritableBlockOrSign(block)) {
                        if ((signpos = signpos.above().immutable()).getY() >= 256) {
                            return;
                        }
                        state = serverlevel.getBlockState(signpos);
                        block = state.getBlock();
                    }
                    try {
                        Block northblock = serverlevel.getBlockState(signpos.north()).getBlock();
                        if (!Util.isOverwritableBlockOrSign(northblock)) {
                            serverlevel.setBlockAndUpdate(signpos, (BlockState)Blocks.OAK_WALL_SIGN.defaultBlockState().setValue((Property)WallSignBlock.FACING, (Comparable)Direction.SOUTH));
                        } else {
                            serverlevel.setBlockAndUpdate(signpos, Blocks.OAK_SIGN.defaultBlockState());
                        }
                    }
                    catch (ConcurrentModificationException northblock) {
                        // empty catch block
                    }
                    BlockEntity te = serverlevel.getBlockEntity(signpos);
                    if (!(te instanceof SignBlockEntity)) {
                        return;
                    }
                    SignBlockEntity signentity = (SignBlockEntity)te;
                    signentity.setText(signentity.getFrontText().setMessage(0, (Component)Component.literal((String)"[Area] 60")), true);
                    TileEntityFunctions.updateTileEntity((Level)serverlevel, (BlockPos)signpos, (BlockEntity)signentity);
                }
            }
            processChunks.get(serverlevel).remove(0);
        }
    }

    public static void onChunkLoad(ServerLevel serverlevel, LevelChunk chunk) {
        if (!serverlevel.getServer().getWorldData().worldGenOptions().generateStructures()) {
            return;
        }
        ChunkPos chunkpos = chunk.getPos();
        if (((ArrayList)HashMapFunctions.computeIfAbsent(cachedchunks, (Object)serverlevel, k -> new ArrayList())).contains(chunkpos)) {
            return;
        }
        ((List)HashMapFunctions.computeIfAbsent(processChunks, (Object)serverlevel, k -> new ArrayList())).add(chunkpos);
    }
}

