/*
 * Decompiled with CFR 0.152.
 */
package net.anvian.bee_info.mixin;

import java.util.List;
import net.anvian.bee_info.Constants;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={BeehiveBlock.class})
public abstract class BeehiveBlockMixin
extends BaseEntityBlock {
    @Final
    @Shadow
    public static int MAX_HONEY_LEVELS;
    @Unique
    private final ChatFormatting moreBeeInfo$defaultFormatting = ChatFormatting.YELLOW;

    protected BeehiveBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> componentList, TooltipFlag tooltipFlag) {
        List beeData = (List)itemStack.getOrDefault(DataComponents.BEES, List.of());
        BlockItemStateProperties blockState = (BlockItemStateProperties)itemStack.get(DataComponents.BLOCK_STATE);
        if (blockState != null && !blockState.isEmpty()) {
            this.moreBeeInfo$appendHoneyLevelText(componentList, blockState);
            this.moreBeeInfo$appendBeeCountText(componentList, beeData);
        }
    }

    @Unique
    private void moreBeeInfo$appendHoneyLevelText(List<Component> componentList, BlockItemStateProperties blockState) {
        try {
            int honeyLevel = Integer.parseInt(blockState.properties().getOrDefault("honey_level", "0"));
            MutableComponent levelText = Component.translatable((String)"tooltip.honey").append(": ").append(honeyLevel + "/" + MAX_HONEY_LEVELS).withStyle(this.moreBeeInfo$defaultFormatting);
            componentList.add((Component)levelText);
        }
        catch (NumberFormatException e) {
            Constants.LOG.error("Failed to parse honey level from block state: {}", (Object)blockState);
        }
    }

    @Unique
    private void moreBeeInfo$appendBeeCountText(List<Component> componentList, List<BeehiveBlockEntity.Occupant> beeData) {
        int MAX_BEES = 3;
        MutableComponent beeText = Component.translatable((String)"tooltip.bees").append(": ").append(beeData.size() + "/3").withStyle(this.moreBeeInfo$defaultFormatting);
        componentList.add((Component)beeText);
    }
}

