package org.codeberg.zenxarch.zombies;

import static net.minecraft.class_2186.*;
import static net.minecraft.class_2232.*;
import static net.minecraft.class_2170.*;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_1308;
import net.minecraft.class_2168;
import net.minecraft.class_2170.class_5364;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2338;
import net.minecraft.class_3730;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_7924;
import net.minecraft.class_9433;
import net.minecraft.class_9652;
import org.codeberg.zenxarch.zombies.data.entity.MobAttachments;
import org.codeberg.zenxarch.zombies.difficulty.ExtendedDifficulty;
import org.codeberg.zenxarch.zombies.entity.ExtendedZombieEntity;
import org.codeberg.zenxarch.zombies.entity.variant.MobVariant;
import org.codeberg.zenxarch.zombies.registry.ZombieRegistryKeys;

public final class DebugCommands {
  private DebugCommands() {
    throw new IllegalStateException("Utility class");
  }

  static void registerDebugCommands(
      CommandDispatcher<class_2168> dispatcher,
      class_7157 registryAccess,
      class_5364 environment) {
    dispatcher.register(
        method_9247("zgiveloot")
            .then(
                method_9244("entity", method_9309())
                    .then(
                        method_9244("identifier", method_9441()).executes(DebugCommands::zgiveloot))));

    dispatcher.register(
        method_9247("zspawnvariant")
            .then(
                method_9244("mob_variant", mobVariant(registryAccess))
                    .executes(DebugCommands::zspawnvariant)));
  }

  private static int zgiveloot(CommandContext<class_2168> ctx)
      throws CommandSyntaxException {
    var entity = class_2186.method_9313(ctx, "entity");
    var id = class_2232.method_9443(ctx, "identifier");
    if (entity instanceof class_1308 mob) {
      MobAttachments.initEquipment(
          mob,
          ctx.getSource().method_9225(),
          new class_9652(class_5321.method_29179(class_7924.field_50079, id), 1.0f),
          new ExtendedDifficulty(ctx.getSource().method_9225(), mob.method_24515()));
    }
    return 0;
  }

  private static int zspawnvariant(CommandContext<class_2168> ctx)
      throws CommandSyntaxException {
    var world = ctx.getSource().method_9225();
    var pos = ctx.getSource().method_9222();
    var zombie = new ExtendedZombieEntity(world);
    zombie.method_60949(pos, world.field_9229.method_43057() * 360.0F, 0.0F);
    zombie.method_5943(
        world,
        world.method_8404(class_2338.method_49638(pos)),
        class_3730.field_16462,
        new ExtendedZombieEntity.ExtendedZombieData(
            MobVariantArgumentType.getVariant(ctx, "mob_variant"), false, false));
    world.method_30771(zombie);
    return 0;
  }

  public static MobVariantArgumentType mobVariant(class_7157 registryAccess) {
    return new MobVariantArgumentType(registryAccess);
  }

  public static class MobVariantArgumentType extends class_9433<MobVariant> {

    public MobVariantArgumentType(class_7157 registryAccess) {
      super(registryAccess, ZombieRegistryKeys.MOB_VARIANT, MobVariant.CODEC);
    }

    @SuppressWarnings("unchecked")
    public static class_6880<MobVariant> getVariant(
        CommandContext<class_2168> context, String argument) {
      return context.getArgument(argument, class_6880.class);
    }
  }
}
