package org.codeberg.zenxarch.zombies.client;

import net.minecraft.class_10086;
import net.minecraft.class_1642;
import net.minecraft.class_3532;
import net.minecraft.class_3886;
import net.minecraft.class_4587;
import net.minecraft.class_5617.class_5618;
import net.minecraft.class_7833;
import org.codeberg.zenxarch.zombies.data.entity.MobAttachments;

public class ExtendedZombieEntityRenderer extends class_3886 {

  public ExtendedZombieEntityRenderer(class_5618 context) {
    super(context);
    this.method_4046(new ExtendedZombieEntityOverlayRenderer(this));
  }

  @Override
  public class_10086 method_55269() {
    return new ExtendedZombieEntityRenderState();
  }

  @Override
  public void method_62369(class_1642 zombie, class_10086 state, float f) {
    super.method_62369(zombie, state, f);
    if (state instanceof ExtendedZombieEntityRenderState exstate) {
      exstate.overlay = zombie.getAttached(MobAttachments.OVERLAY);
    }
  }

  @Override
  protected void setupTransforms(
      class_10086 state, class_4587 matrices, float bodyYaw, float baseHeight) {
    super.method_4058(state, matrices, bodyYaw, baseHeight);
    if (state.field_53403 > 0f) {
      var finalPitch = class_3532.method_16439(state.field_53403, 0f, -10f - state.field_53448);
      matrices.method_49278(
          class_7833.field_40714.rotationDegrees(finalPitch),
          0,
          (state.field_53330 / 2) / baseHeight,
          0);
    }
  }
}
