package org.codeberg.zenxarch.zombies.data.entity.effect;

import static net.minecraft.class_9734.*;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1293;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_3218;
import net.minecraft.class_5862;
import net.minecraft.class_5863;
import net.minecraft.class_9734;
import org.codeberg.zenxarch.zombies.Zombies;
import org.codeberg.zenxarch.zombies.data.entity.effect.pair.AllOfMobEffect;
import org.codeberg.zenxarch.zombies.data.entity.effect.pair.ConditionalSpawnEffect;
import org.codeberg.zenxarch.zombies.data.entity.effect.pair.ConvertToEntityTypeEffect;
import org.codeberg.zenxarch.zombies.data.entity.effect.pair.DefaultMobEffect;
import org.codeberg.zenxarch.zombies.data.entity.effect.pair.HealFromDamage;
import org.codeberg.zenxarch.zombies.data.entity.effect.pair.IntervalMobEffect;
import org.codeberg.zenxarch.zombies.data.entity.effect.pair.RandomMobEffect;
import org.codeberg.zenxarch.zombies.data.entity.effect.pair.SingleMobEffect;
import org.codeberg.zenxarch.zombies.data.entity.effect.pair.StatusMobEffect;
import org.codeberg.zenxarch.zombies.data.entity.effect.pair.SwapMobEffect;
import org.codeberg.zenxarch.zombies.data.entity.effect.single.FreezeEffect;
import org.codeberg.zenxarch.zombies.data.entity.effect.single.IgniteEffect;
import org.codeberg.zenxarch.zombies.data.entity.effect.single.SpawnParticleEffect;
import org.codeberg.zenxarch.zombies.registry.ZombieRegistries;
import org.jetbrains.annotations.Nullable;

public interface MobEffect {
  public static final Codec<MobEffect> CODEC =
      Codec.withAlternative(
          ZombieRegistries.MOB_EFFECT.method_39673().dispatch(MobEffect::getCodec, Function.identity()),
          DefaultMobEffect.CODEC.codec());

  public void run(class_3218 world, class_1308 mob, @Nullable class_1309 adversery);

  public MapCodec<? extends MobEffect> getCodec();

  public static void init() {
    register("default", DefaultMobEffect.CODEC);
    register("all_of", AllOfMobEffect.CODEC);
    register("random", RandomMobEffect.CODEC);
    register("single", SingleMobEffect.CODEC);
    register("status_effect", StatusMobEffect.CODEC);
    register("swap", SwapMobEffect.CODEC);
    register("conditional", ConditionalSpawnEffect.CODEC);
    register("heal", HealFromDamage.CODEC);
    register("convert_to", ConvertToEntityTypeEffect.CODEC);
    register("interval", IntervalMobEffect.CODEC);
  }

  private static void register(String id, MapCodec<? extends MobEffect> codec) {
    class_2378.method_10230(ZombieRegistries.MOB_EFFECT, Zombies.id(id), codec);
  }

  public static SwapMobEffect swapPositions() {
    return SwapMobEffect.create();
  }

  public static SingleMobEffect toPlayer(LivingEffect effect) {
    return new SingleMobEffect(effect, false);
  }

  public static SingleMobEffect toZombie(LivingEffect effect) {
    return new SingleMobEffect(effect, true);
  }

  public static SingleMobEffect ignite(float seconds) {
    return toPlayer(new IgniteEffect(seconds));
  }

  public static SingleMobEffect freeze() {
    return toPlayer(FreezeEffect.create());
  }

  public static MobEffect random(MobEffect... effect) {
    return RandomMobEffect.create(effect);
  }

  public static MobEffect statusEffect(class_1293... builders) {
    if (builders.length == 0) return DefaultMobEffect.create();
    return new StatusMobEffect(List.of(builders));
  }

  public static SingleMobEffect spawnParticles(
      class_2394 particle,
      class_9734.class_9735 horizontalPosition,
      class_9734.class_9735 verticalPosition,
      class_9734.class_9738 horizontalVelocity,
      class_9734.class_9738 verticalVelocity,
      class_5863 speed) {
    return toZombie(
        new SpawnParticleEffect(
            new class_9734(
                particle,
                horizontalPosition,
                verticalPosition,
                horizontalVelocity,
                verticalVelocity,
                speed)));
  }

  public static SingleMobEffect spawnParticles(class_2394 particle, float speed) {
    var floatProvider = class_5862.method_33908(speed);
    return spawnParticles(
        particle,
        method_60252(),
        method_60252(),
        method_60250(floatProvider),
        method_60250(floatProvider),
        floatProvider);
  }
}
