package org.codeberg.zenxarch.zombies.data.entity.effect.pair;

import com.mojang.serialization.MapCodec;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_5454;
import org.codeberg.zenxarch.zombies.data.entity.effect.MobEffect;
import org.jetbrains.annotations.Nullable;

public record SwapMobEffect() implements MobEffect {
  private static final SwapMobEffect INSTANCE = new SwapMobEffect();
  public static final MapCodec<SwapMobEffect> CODEC = MapCodec.unit(INSTANCE);

  private static class_5454 getTeleportTarget(class_3218 world, class_1309 living) {
    return new class_5454(
        world,
        living.method_73189(),
        living.method_18798(),
        living.method_36454(),
        living.method_36455(),
        class_5454.field_52245);
  }

  @Override
  public void run(class_3218 world, class_1308 mob, @Nullable class_1309 adversery) {
    if (adversery == null) return;

    var toAdversary = getTeleportTarget(world, adversery);
    var toSelf = getTeleportTarget(world, mob);

    mob.method_5731(toAdversary);
    adversery.method_5731(toSelf);
  }

  @Override
  public MapCodec<SwapMobEffect> getCodec() {
    return CODEC;
  }

  public static SwapMobEffect create() {
    return INSTANCE;
  }
}
